#include "mbed.h"
#include "nRF2401A.h"

DigitalOut  myled(LED1);
nRF2401A    rf1(p5, p6, p7, p8, p9);
nRF2401A    rf2(p21, p22, p23, p24, p25);

Serial pc(USBTX, USBRX);

int main() {

    wait(0.005);

    pc.printf("Hello nRF2401A\n\r");
    
    rf1.setDataPayloadLength(4 << 3)
       .setAddress(0x0, 0x0, 0xa6, 0xa6, 0xa6, 3 << 3)
       .setCRCMode(nRF2401A::NO_CRC)
//       .setCRCMode(nRF2401A::CRC_8)
       .setDataRate(nRF2401A::BIT_RATE_250KBITS)
       .setChannel(0x02);
       
    rf1.printControlPacket(pc);
    
    rf2.setDataPayloadLength(4 << 3)
       .setAddress(0x0, 0x0, 0x53, 0x53, 0x53, 3 << 3)
       .setCRCMode(nRF2401A::NO_CRC)
//       .setCRCMode(nRF2401A::CRC_8)
       .setDataRate(nRF2401A::BIT_RATE_250KBITS)
       .setChannel(0x02);
       
    rf2.printControlPacket(pc);
    
    rf1.flushControlPacket();
    rf2.flushControlPacket();
    
    nRF2401A::address_t rf2_addr = {0x0, 0x0, 0x53, 0x53, 0x53};
    uint8_t msg[] = {0x01, 0x01, 0x01, 0x01};
    uint32_t *msg32 = (uint32_t *) msg;
        
    while(1) {
            
        rf1.sendMsg(rf2_addr, 3 << 3, msg, 4 << 3);
        *msg32 += 1;
        
        myled = 1;
        wait(0.25);
        
        rf2.printDataPacket(pc);
        
        myled = 0;
        wait(0.25);
    }
}
