#ifndef DATACOMM_H
#define DATACOMM_H

#include <map>
#include <string>

#include "mbed.h"
/**
* @file dataComm.h
* @brief This header file describes dataComm, an object that receives and processes messages sent to the controlbed via SPI.
* shares many functions with BluetoothComm on the controlbed
* @author Michael Ling
* @date 2/4/2015
*/

class dataComm
{
public:
    dataComm();

    bool parity(short c);
    char* get_checksum(char* b, int len);
    void set_values(std::map<string, short> newValues);


    void send_values(char* paramList);
    void send_read_only_values();
    bool msg_check(char* msg, int len);
    void process_write(short int *message, int len);
    int main();
    short generic_get(string var);
    void generic_set(string var, short newval);

private:

    //Map containing values of Exo parameters
    std::map<std::string, short> _paramMap;
    //Maps parameter indices to param names
    std::string _indexMap[50];
    //Last received MSG
    char _msg[50];

    char _curMsg[50];
    int _numVars;
    //Last sent command
    char _lastCmd[50];
    int _failures;
    //Readonly Parameters
    int _numReadOnlyParams;
    short _readOnlyParams[12];
    //Indices where an escape char. is needed
    int _escapeNeeded[9];
    int _escapesNeeded;
    int _len;
    int _counter;
    bool _inMsg;
    int _data;

    //START/END bytes, parameter indices
    static const char START = 0xff;
    static const char END = 0xfe;
    static const char KPSTANCE_IND = 0x0;
    static const char KPSWING_IND = 0x1;
    static const char KPSTAND_IND = 0x2;
    static const char KPSIT_IND = 0x3;
    static const char KPUP_IND = 0x4;
    static const char KPDOWN_IND = 0x5;
    static const char KDSTANCE_IND = 0x6;
    static const char KDSWING_IND = 0x7;
    static const char KDSTAND_IND = 0x8;
    static const char KDSIT_IND = 0x9;
    static const char KDUP_IND = 0xa;
    static const char KDDOWN_IND = 0xb;
    static const char STAND_IND = 0xc;
    static const char SIT_IND = 0xd;
    static const char BENT_IND = 0xe;
    static const char FORWARD_IND = 0xf;
    static const char REAR_IND = 0x10;
    static const char IMU_IND = 0x11;
    static const char RETRACT_IND = 0x12;
    static const char EXTEND_IND = 0x13;
    static const char LOCK_IND = 0x14;
    static const char RATE_IND = 0x15;
    static const char SUASST_IND = 0x16;
    static const char SUTIME_IND = 0x17;
    static const char SDASST_IND = 0x18;
    static const char SDTIME_IND = 0x19;
    static const char WALK_IND = 0x1a;
    static const char STEPLEN_IND = 0x1b;
    static const char STEPTIME_IND = 0x1c;
    static const char HIPFLEX_IND = 0x1d;
    static const char PHASESHIFT_IND = 0x1e;
    static const char MAXAMP_IND = 0x1f;
    static const char STANCESTART_IND = 0x20;
    static const char STANCEEND_IND = 0x21;


    //MIN and MAX values for the various parameters
    static const float MIN_STAND = -15;
    static const float MAX_STAND = 15;
    static const float MIN_SIT = 70;
    static const float MAX_SIT = 110;
    static const float MIN_BENT = 90;
    static const float MAX_BENT = 140;
    static const float MIN_SUASST = -.17;
    static const float MAX_SUASST = -.11;
    static const float MIN_SDASST = -.03;
    static const float MAX_SDASST = -.02;
    static const float MIN_SDTIME = 3.2;
    static const float MAX_SDTIME = 4.8;
    static const float MIN_WALK = 0;
    static const float MAX_WALK = 10;
    static const float MIN_STEPTIME = 700;
    static const float MAX_STEPTIME = 1300;
    static const float MIN_STANDUPTIME = 0.5;
    static const float MAX_STANDUPTIME = 1.5;
    
    static const float MIN_STEPLEN = -10;
    static const float MAX_STEPLEN = 10;
    static const float MIN_HIPFLEX = 20;
    static const float MAX_HIPFLEX = 40;
    static const float MIN_PHASESHIFT = 400;
    static const float MAX_PHASESHIFT = 600;

    //Indicates a readonly request
    static const char READONLY_IND = 0x3f;

    //Error codes
    static const char START_ERR = 1;
    static const char END_ERR = 2;
    static const char PARITY_ERR = 3;
    static const char CHECKSUM_ERR = 4;
    static const char VAR_ERR = 5;
    static const char DATA_ERR =  6;
    static const char RW_ERR = 7;
  
};
#endif
