#include "mbed.h"
#include "SDFileSystem.h"

//SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
SDFileSystem sd(p11, p12, p13, p14, "sd"); // the pinout on the mbed Cool Components workshop board

Timer t_debug; //Debug Timer

Serial pc(USBTX, USBRX);//tx, rx, PC serial connection through USB, use TerraTerm

/**
SD_read opens file fp, reads in the last "length" worth of hexadecimal integers into array
**/
int *SD_read(FILE *fp, int array[], int length)
{
    //shift to the end of the file and go back accounting for the commas, spaces, \n, and \r (6 places per data)
    fseek(fp, -6*length, SEEK_END);
    //cycle through the length of the vector and read the values.
    for(int i=0; i<length; i++) {
        fscanf(fp, "%x, ", &array[i]);
    }
    return array;
}

void SD_write(FILE *fp, int array[], int length)
{
    for(int i=0; i<length-1; i++) {
        fprintf(fp,"%04x, ", array[i]);
    }
    fprintf(fp, "%04x\r\n", array[length-1]);
}

int main()
{
    pc.baud(912600);
    pc.printf("Hello World!\r\n");

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w+");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    t_debug.start();
    for(int i=0; i<=1000; i++) {
        int array[]= {i,i+1,i+2,i+3,i+4,i+5,i+6,i+7,i+8,i+9,i+10,i+11,i+12,i+13,i+14,i+15};
        SD_write(fp,array , sizeof(array)/sizeof(array[0]));
    }
    t_debug.stop();
    float test=t_debug.read_ms();
    pc.printf("Write Time: %f \r\n", test);
    int data[16];
    pc.printf("Testing\r\n");
    t_debug.reset();
    t_debug.start();
    int *p=data;
    p=SD_read(fp, data, sizeof(data)/sizeof(data[0]));
    t_debug.stop();
    test=t_debug.read_us();
    pc.printf("Read Time: %f \r\n", test);
    for(int i=0; i<16; i++) {
        pc.printf("%x, ", data[i]);
    }
    fclose(fp);
    pc.printf("\r\n");
    pc.printf("Goodbye World!\r\n");
}
