#ifndef ENCODER_H
#define ENCODER_H

#include "mbed.h"

// Define BaseClass Encoder

class Encoder
{
public:
    // Constructor
    Encoder(PinName mosi, PinName miso, PinName sck, PinName ncs);
    float angle();
    bool parityFlag();
    bool encFlag();
    void init(float zero_ang);
    void flip();
    short int readRaw();
    // Functions
private:
    /**
    * SPI bus for communicating with the encoder.
    **/
    SPI _spi;
    /**
    * SPI chip select pin for communicating with the encoder.
    **/
    DigitalOut _cs;
    /**
    *Calculates the parity of the input.
    *@params x The message that you want to calculate the parity of.
    *@returns A boolean variable that represents the parity of the message.
    **/
    bool parity_calc(int x);
    /**
    *Sign variable used to flip the direction of the encoder if needed.  
    **/
    int sign;
    /**
    *Reads the encoder, does parity check, and stores the error flag.
    *@returns An unsigned integer which is the number of ticks away from the zero position.
    **/
    int read();
    /**
    *The parity comparison of the previous transmission
    **/
    bool parity;
    /**
    *The encoder flag of the previous transmission
    **/
    bool enc_flag;
    /**
    *Zero angle set point for standing position.
    **/
    float zero_ang;
    /**
    *The raw angle from the encoder in encoder ticks.
    **/
    short int raw;
    /**
    *Used for translating from encoder ticks to degrees.
    **/
    const float enc2deg;

};

#endif

