#ifndef ENCODER_H
#define ENCODER_H

#include "mbed.h"

// Define BaseClass Encoder

class Encoder
{
public:
    // Constructor
    Encoder(PinName mosi, PinName miso, PinName sck, PinName ncs);
    float angle();
    bool parityFlag();
    bool encFlag();
    void init(float zero_ang);
    void flip();
    short int readRaw();
    // Functions
private:
    SPI _spi;
    DigitalOut _cs;
    bool parity_calc(int x);
    int sign;
    int read();
    bool parity;
    bool enc_flag;
    //zero_ang for standing position
    float zero_ang;
    short int raw;


    // Variables
    const float enc2deg;

};

#endif

