#ifndef _ACC_H
#define _ACC_H

#include "mbed.h"

class ACC {
public:
    typedef enum {
        ACC_MODE_STANDBY,
        ACC_MODE_MEASURE,
        ACC_MODE_LEVEL, /* level detection */
        ACC_MODE_PULSE /* pulse detection */
    } acc_mode_t;

    typedef enum {
        ACC_RANGE_8G,
        ACC_RANGE_2G,
        ACC_RANGE_4G
    } acc_range_t;


    ACC(PinName sda, PinName scl);
    void read(int *x, int *y, int *z);
    void setRange(acc_range_t range);
    void setMode(acc_mode_t mode);

private:
    void setModeControl(int mctl);
    int getModeControl(void);
    int getStatus(void);

    I2C _i2c;
};

#endif //_ACC_H