/**
* This project contains a an example monitoring the light sensor,
* accelerometer and trim potentiometer and
* displaying the values on the OLED display.
*/

#include "mbed.h"
#include "adc.h"
#include "acc.h"
#include "light.h"
#include "EAOLED.h"

DigitalOut myled(LED1);
//Initialise ADC to 100000 sample rate and cclk divide set to 1
ADC adc(100000, 1);
EAOLED oled(p5, p6, p7, p8, p25); // mosi, dnc, sclk, cs, power
ACC acc(p28, p27);
LIGHT light(p28, p27);


int main() {
    int xoff = 0;
    int yoff = 0;
    int zoff = 0;

    int x = 0;
    int y = 0;
    int z = 0;

    int lux = 0;
    
    //Set up ADC on pin 15 (channel 0)
    adc.setup(p15,1);
    //No interrupt
    adc.interrupt_state(p15, 0);
    //Measure pin 15
    adc.select(p15);


    light.enable();
    light.setRange(light.LIGHT_RANGE_4000);
    
    // Assume base board in zero-g position when reading first value.
    acc.read(&x, &y, &z);
    xoff = 0-x;
    yoff = 0-y;
    zoff = 64-z;
    //Clear screen
    oled.cls();
    oled.locate(0,1);
    oled.printf("Light: ");
    oled.locate(0,2);
    oled.printf("Pot  : ");
    oled.locate(0,3);
    oled.printf("Acc x: ");
    oled.locate(0,4);
    oled.printf("Acc y: ");
    oled.locate(0,5);
    oled.printf("Acc z: ");
    
    oled.locate(0,6);
    oled.printf("Petar");

    while (1) { 
              
        //light
        lux = light.read();
        oled.locate(8,1);
        oled.printf("    ");
        oled.locate(8,1);
        oled.printf("%d", lux);
        
        
        adc.start();
        //Wait for it to complete
        while (!adc.done(p15));
        //Get trimpot
        int trimpot = adc.read(p15);
        oled.locate(8,2);
        oled.printf("    ");
        oled.locate(8,2);
        oled.printf("%d", trimpot);

        // Accelerometer
        acc.read(&x, &y, &z);
        x = x+xoff;
        y = y+yoff;
        z = z+zoff;


        oled.locate(8,3);
        oled.printf("    ");
        oled.locate(8,3);
        oled.printf("%d",x);


        oled.locate(8,4);
        oled.printf("    ");
        oled.locate(8,4);
        oled.printf("%d",y);


        oled.locate(8,5);
        oled.printf("    ");
        oled.locate(8,5);
        oled.printf("%d",z);


        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
