#ifndef _LIGHT_H
#define _LIGHT_H

#include "mbed.h"

class LIGHT {
public:
    typedef enum {
        LIGHT_MODE_D1,
        LIGHT_MODE_D2,
        LIGHT_MODE_D1D2
    } light_mode_t;

    typedef enum {
        LIGHT_WIDTH_16BITS,
        LIGHT_WIDTH_12BITS,
        LIGHT_WIDTH_08BITS,
        LIGHT_WIDTH_04BITS
    } light_width_t;

    typedef enum {
        LIGHT_RANGE_1000,
        LIGHT_RANGE_4000,
        LIGHT_RANGE_16000,
        LIGHT_RANGE_64000
    } light_range_t;

    typedef enum {
        LIGHT_CYCLE_1,
        LIGHT_CYCLE_4,
        LIGHT_CYCLE_8,
        LIGHT_CYCLE_16
    } light_cycle_t;


    LIGHT(PinName sda, PinName scl);
    void enable (void);
    int read(void);
    void setMode(light_mode_t mode);
    void setWidth(light_width_t width);
    void setRange(light_range_t newRange);
    void setHiThreshold(int luxTh);
    void setLoThreshold(int luxTh);
    void setIrqInCycles(light_cycle_t cycles);
    bool getIrqStatus(void);
    void clearIrqStatus(void);
    void shutdown(void);

private:
    char readCommandReg(void);
    char readControlReg(void);

    int range;
    int width;
    I2C _i2c;

};
#endif //_LIGHT_H
