#include "mbed.h"

uint8_t LED_FREQ=5;

void pressed(void);

DigitalOut myled(LED1);
InterruptIn event(USER_BUTTON);

int main() {
    printf("Flicker Fusion Threshold Test\n");
    printf("Frequency: %uhz\n", LED_FREQ);
    
    event.fall(&pressed);   // Increase frequency when button is pressed.

    while(1) {
        myled = 1;          // Turn ON the led
        wait((float) 1 / LED_FREQ);
        myled = 0;          // Turn OFF the led
        wait((float) 1 / LED_FREQ);
    }
}

void pressed(void)
{
    // Increase frequency in 5hz steps; max = 100hz
    LED_FREQ = (LED_FREQ >= 100 ? LED_FREQ = 5 : LED_FREQ+=5);
    
    // Print to serial the new frequency
    printf("Frequency: %uhz\n", LED_FREQ);
}