#include "mbed.h"
#include "MPL3115A2.h"

#define MPL3115A2_I2C_ADDRESS (0x60<<1)
#define 
DigitalOut myled(LED1);
MPL3115A2 wigo_sensor1( PTC9, PTC8, MPL3115A2_I2C_ADDRESS);
Serial pc(USBTX, USBRX);

/* pos [0] = altimeter or pressure value */
/* pos [1] = temperature value */
float sensor_data[2];

void dataready( void);      // callback function for data streaming using Interrupt
void alttrigger( void);

/* Helper functions to print out as float the raw data */
float print_PressureValue( unsigned char *dt);
float print_AltimiterValue( unsigned char *dt);
float print_TemperatureValue( unsigned char *dt);

int main() {
    pc.baud(9600);
    pc.printf("MPL3115A2 Sensor. [%X]\r\n", wigo_sensor1.getDeviceID());
    // ***** Data acquisition using polling method and delta values
    // Array for the dela values
    //float delta[2];
    
    // Set over sampling value (see MPL3115A2.h for details)
    wigo_sensor1.Oversample_Ratio( OVERSAMPLE_RATIO_128);
    // Configure the sensor as Barometer.
    wigo_sensor1.Barometric_Mode();
    int i =0;
    while(1) {
        //
        if ( wigo_sensor1.getAllData( &sensor_data[0]) ) {
            pc.printf("\tPressure: %f\tTemperature: %f\r\n", sensor_data[0], sensor_data[1]);
            //pc.printf("\tDelatPress: %f\tDeltaTemp: %f\r\n", delta[0], delta[1]);
        }else{
            pc.printf("Not reading any more");
        }
        pc.printf("Measurement# %d",i);
        i++;
        //
        wait( 1.0);
    }

    
    
}

void dataready( void)
{
    wigo_sensor1.getAllData( &sensor_data[0]);
    pc.printf("\tPressure: %f\tTemperature: %f\r\n", sensor_data[0], sensor_data[1]);
}

float print_PressureValue( unsigned char *dt)
{
    unsigned int prs;
    float fprs;

    /*
    * dt[0] = Bits 12-19 of 20-bit real-time Pressure sample. (b7-b0)
    * dt[1] = Bits 4-11 of 20-bit real-time Pressure sample. (b7-b0)
    * dt[2] = Bits 0-3 of 20-bit real-time Pressure sample (b7-b4)
    */
    prs = (dt[0]<<10) | (dt[1]<<2) | (dt[2]>>6);
    //
    fprs = (float)prs * 1.0f;
    
    if ( dt[2] & 0x20)
        fprs += 0.25f;
    if ( dt[2] & 0x10)
        fprs += 0.5f;
    
    return fprs;
}

float print_AltimiterValue( unsigned char *dt)
{
    unsigned short altm;
    float faltm;

    /*
    * dt[0] = Bits 12-19 of 20-bit real-time Altitude sample. (b7-b0)
    * dt[1] = Bits 4-11 of 20-bit real-time Altitude sample. (b7-b0)
    * dt[2] = Bits 0-3 of 20-bit real-time Altitude sample (b7-b4)
    */    
    altm = (dt[0]<<8) | dt[1];
    //
    if ( dt[0] > 0x7F) {
        altm = ~altm + 1;
        faltm = (float)altm * -1.0f;
    } else {
        faltm = (float)altm * 1.0f;
    }
    //
    faltm = faltm+((float)(dt[2]>>4) * 0.0625f);
    return faltm;
}

float print_TemperatureValue( unsigned char *dt)
{
    unsigned short temp;
    float ftemp;
    
    /*
    * dt[0] = Bits 4-11 of 16-bit real-time temperature sample. (b7-b0)
    * dt[1] = Bits 0-3 of 16-bit real-time temperature sample. (b7-b4)
    */
    temp = dt[0];
    //
    if ( dt[0] > 0x7F) {
        temp = ~temp + 1;
        ftemp = (float)temp * -1.0f;
    } else {
        ftemp = (float)temp * 1.0f;
    }
    //
    ftemp = ftemp+((float)(dt[1]>>4) * 0.0625f);
    return ftemp;

}

