// W25Q80BV.cpp
//Changes by Ciprijal
#include"W25Q80BV.h"

// Pinout: PTD2,PTD3, PTD1, PTC7
// CONSTRUCTOR 
W25Q80BV::W25Q80BV(PinName mosi, PinName miso, PinName sclk, PinName cs):_cs(cs),_mosi(mosi),_miso(miso),_sclk(sclk){
    
}
//Get ID
 int W25Q80BV::getMID( ){
    int ID = 0;
    chipEnable();
    this->writeSPI(DEV_ID );
    this->writeSPI(DUMMY_ADDR);
    this->writeSPI(DUMMY_ADDR);
    this->writeSPI(DUMMY_ADDR);
    this->writeSPI(DUMMY_ADDR);
    ID      = this->writeSPI(DUMMY_ADDR);
    chipDisable(); 
    return ID;
} 


// READING
int W25Q80BV::readByte(int addr) {
    chipEnable();
    this->writeSPI(READ_DATA);
    this->writeSPI((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->writeSPI((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->writeSPI((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    int response = this->writeSPI(DUMMY_ADDR);
    chipDisable();
    return response;
}
int W25Q80BV::readByte(int a2, int a1, int a0) {
   chipEnable();
   this->writeSPI(READ_DATA);
   this->writeSPI(a2);
   this->writeSPI(a1);
   this->writeSPI(a0);
   int response = this->writeSPI(DUMMY_ADDR);
    chipDisable();
    return response;
}
void W25Q80BV::readStream(int addr, char* buf, int count) {
    if (count < 1)
        return;
    chipEnable();
    this->writeSPI(READ_DATA);
    this->writeSPI((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->writeSPI((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->writeSPI((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++)
        buf[i] =  this->writeSPI(DUMMY_ADDR);
    chipDisable();
}

// WRITING
void W25Q80BV::writeByte(int addr, int data) {
    writeEnable();
    chipEnable();
    this->writeSPI(WRITE_DATA);
    this->writeSPI((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->writeSPI((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->writeSPI((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->writeSPI(data);
    chipDisable();
    writeDisable();
    wait(WAIT_TIME);//NO ESTOY SEGURO SI ASI HAY QUE ESPERAR
}
void W25Q80BV::writeByte(int a2, int a1, int a0, int data) {
    writeEnable();
    chipEnable();
    this->writeSPI(WRITE_DATA);
    this->writeSPI(a2);
    this->writeSPI(a1);
    this->writeSPI(a0);
    this->writeSPI(data);
    chipDisable();
    writeDisable();
    wait(WAIT_TIME);
}
void W25Q80BV::writeStream(int addr, char* buf, int count) {
    if (count < 1)
        return;
    writeEnable();
    chipEnable();
    this->writeSPI(WRITE_DATA);
    this->writeSPI((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->writeSPI((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->writeSPI((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++)
        this->writeSPI(buf[i]);
    chipDisable();
    writeDisable();
    wait(WAIT_TIME);
}

//ERASING
void W25Q80BV::chipErase() {
    writeEnable();
    chipEnable();
    this->writeSPI(CHIP_ERASE);
    chipDisable();
    writeDisable();
    wait(WAIT_TIME);
}
    

//Private Functions
void W25Q80BV::writeEnable() {
    chipEnable();
    this->writeSPI(WRITE_ENABLE);
    chipDisable();
}
void W25Q80BV::writeDisable() {
    chipEnable();
    this->writeSPI(WRITE_DISABLE);
    chipDisable();
}
void W25Q80BV::chipEnable() {
    _cs = 0;
}
void W25Q80BV::chipDisable() {
    _cs = 1;
}
//Sends and receives 1 byte of SPI data MSB endianness
int W25Q80BV::writeSPI(int data){
    int aux =0,aux2=0,i=0,read=0;
    //aux=data;
    for(i=0;i<8;i++){
        //output
        _sclk   =   0;
        aux     =   data&0x80;
        aux     >>= 7;
        _mosi   =   aux;
        data    <<= 1;
        
        //input
        _sclk   =   1;
        //maybe wait? test it first
        read    <<= 1;
        aux2    =   _miso;
        read    |=  aux2;
    }
    _sclk   =   0;
    return read;
}