#include "mbed.h"
 
//Setup a new class for TMP36 sensor
class LM35
{
public:
    LM35(PinName pin);
    LM35();
    operator float ();
    float read();
private:
//class sets up the AnalogIn pin
    AnalogIn _pin;
};
 
LM35::LM35(PinName pin) : _pin(pin)
{
// _pin(pin) means pass pin to the AnalogIn constructor
}
 
float LM35::read()
{
//convert sensor reading to temperature in degrees C
    return (_pin.read()*3.3)*100.0;
}
//overload of float conversion (avoids needing to type .read() in equations)
LM35::operator float ()
{
//convert sensor reading to temperature in degrees C
     return (_pin.read()*3.3)*100.0;
}
           