#include "mbed.h"
 
//Setup a new class for TMP36 sensor
class ABP
{
public:
    ABP(PinName pin);
    ABP();
    operator float ();
    float read();
private:
//class sets up the AnalogIn pin
    AnalogIn _pin;
};
 
ABP::ABP(PinName pin) : _pin(pin)
{
// _pin(pin) means pass pin to the AnalogIn constructor
}
 
float ABP::read()
{
//convert sensor reading to temperature in degrees C
    return (150*((_pin.read()*3300)-500)/4500)/14.5;
}
//overload of float conversion (avoids needing to type .read() in equations)
ABP::operator float ()
{
//convert sensor reading to temperature in degrees C
     return (150*((_pin.read()*3300)-500)/4500)/14.5;
}
           