#include "MQTTTimer.h"
#include "CayenneMQTTClient.h"
#include "MQTTNetworkIDW01M1.h"
#include "SpwfInterface.h"
#include "ABP.h"
#include "LM35.h"

// Dane do wifi
char* ssid = "FunBox2-20F4";
char* wifiPassword = "3129F7A6C2479CC337E77C5D6A";

// Dane do Cayenne
char* username = "a9472990-3ff6-11eb-a2e4-b32ea624e442";
char* password = "9c7d211eff0e1f0da7d90e036eeaafada2ac5339";
char* clientID = "28d96ff0-3ff8-11eb-8779-7d56e82df461";

SpwfSAInterface interface(D8, D2); // TX, RX
MQTTNetwork<SpwfSAInterface> network(interface);
CayenneMQTT::MQTTClient<MQTTNetwork<SpwfSAInterface>, MQTTTimer> mqttClient(network, username, password, clientID);

DigitalOut led1(LED1);

void outputMessage(CayenneMQTT::MessageData& message)
{
    switch (message.topic)  {
    case COMMAND_TOPIC:
        printf("topic=Command");
        break;
    case CONFIG_TOPIC:
        printf("topic=Config");
        break;
    default:
        printf("topic=%d", message.topic);
        break;
    }
    printf(" channel=%d", message.channel);
    if (message.clientID) {
        printf(" clientID=%s", message.clientID);
    }
    if (message.type) {
        printf(" type=%s", message.type);
    }
    for (size_t i = 0; i < message.valueCount; ++i) {
        if (message.getValue(i)) {
            printf(" value=%s", message.getValue(i));
        }
        if (message.getUnit(i)) {
            printf(" unit=%s", message.getUnit(i));
        }
    }
    if (message.id) {
        printf(" id=%s", message.id);
    }
    printf("\n");
}

void messageArrived(CayenneMQTT::MessageData& message)
{
    int error = 0;
    outputMessage(message);

    if (message.topic == COMMAND_TOPIC) {
        switch(message.channel) {
        case 0:

            led1 = atoi(message.getValue());
        
            if ((error = mqttClient.publishData(DATA_TOPIC, message.channel, NULL, NULL, message.getValue())) != CAYENNE_SUCCESS) {
                printf("Publish LED state failure, error: %d\n", error);
            }
            break;
        }
        
        
        if ((error = mqttClient.publishResponse(message.id, NULL, message.clientID)) != CAYENNE_SUCCESS) {
            printf("Response failure, error: %d\n", error);
        }
    }
}

int connectClient(void)
{
    int error = 0;
    printf("Connecting to %s:%d\n", CAYENNE_DOMAIN, CAYENNE_PORT);
    while ((error = network.connect(CAYENNE_DOMAIN, CAYENNE_PORT)) != 0) {
        printf("TCP connect failed, error: %d\n", error);
        wait(2);
    }

    if ((error = mqttClient.connect()) != MQTT::SUCCESS) {
        printf("MQTT connect failed, error: %d\n", error);
        return error;
    }
    printf("Connected\n");

    
    if ((error = mqttClient.subscribe(COMMAND_TOPIC, CAYENNE_ALL_CHANNELS)) != CAYENNE_SUCCESS) {
        printf("Subscription to Command topic failed, error: %d\n", error);
    }
    if ((error = mqttClient.subscribe(CONFIG_TOPIC, CAYENNE_ALL_CHANNELS)) != CAYENNE_SUCCESS) {
        printf("Subscription to Config topic failed, error:%d\n", error);
    }

    mqttClient.publishData(SYS_VERSION_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, CAYENNE_VERSION);
    mqttClient.publishData(SYS_MODEL_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, "mbedDevice");

    return CAYENNE_SUCCESS;
}

void loop(void)
{
    MQTTTimer timer(1000);
    LM35 LM35(A1); // Wyłowanie klasy z PINEM A0 odpowiadająca czujnik temperatury LM35 
ABP ABP(A0); //Wyłowanie klasy z PINEM A0 odpowiadająca czujniki ciśnienia  ABPMANV150PGAA5 HONEYWELL
double Idealne_cisnienie,bary,ile; // zmienne odpowiadające rózne obliczenia ciśnień 
int wzorzecP,wzorzecT; // zmienne odpowiadjące za wzrocowe cisnieni i temperature
wzorzecP=230000;  //Ciśnieni wzorcowe w kole 
wzorzecT=293;  //Temperatura wzorcowe w kole 
    
    while (true) {
        Idealne_cisnienie=(((wzorzecP)*(LM35.read()+ 273))/(wzorzecT)); 
bary=Idealne_cisnienie/100000;
ile=(bary-ABP.read());
        mqttClient.yield(1000);
        if (!network.connected() || !mqttClient.connected()) {
            network.disconnect();
            mqttClient.disconnect();
            printf("Reconnecting\n");
            while (connectClient() != CAYENNE_SUCCESS) {
                wait(2);
                printf("Reconnect failed, retrying\n");
            }
        }

        if (timer.expired()) {
            int error = 0;
            if ((error = mqttClient.publishData(DATA_TOPIC, 5, TYPE_TEMPERATURE, UNIT_CELSIUS, LM35.read())) != CAYENNE_SUCCESS) {
                printf("Publish temperature failed, error: %d\n", error);
        
            }
                 if ((error = mqttClient.publishData(DATA_TOPIC,2, TYPE_BAROMETRIC_PRESSURE, UNIT_HECTOPASCAL, ABP.read())) != CAYENNE_SUCCESS) 
                 { 
                printf("Publish temperature failed, error: %d\n", error);
                }
             if ((error = mqttClient.publishData(DATA_TOPIC, 3, TYPE_BAROMETRIC_PRESSURE, UNIT_HECTOPASCAL,ile)) != CAYENNE_SUCCESS) 
             
             {
                printf("Publish temperature failed, error: %d\n", error);
            }
            timer.countdown_ms(5000);
            }
    }
}

int main()
{   
    printf("Ladowanie interfejsu \n");
    interface.connect(ssid, wifiPassword, NSAPI_SECURITY_WPA2);
    mqttClient.setDefaultMessageHandler(messageArrived);
    if (connectClient() == CAYENNE_SUCCESS) {
        loop();
    }
    else {
        printf("Connection failed, exiting\n");
    }

    if (mqttClient.connected())
        mqttClient.disconnect();
    if (network.connected())
        network.disconnect();

    return 0;
}

