#include "mbed.h"

//
// Original Code -> http://d.hatena.ne.jp/Coro/searchdiary?word=%2A%5Bmbed%5D
//

PwmOut led(LED1);
DigitalOut activity(LED2);
Serial pc(USBTX, USBRX);
float brightness = 0.0 ;

int main()
{
    // Initialize
    // SET Speed & PUT Text
    //
    pc.baud( 115200 );
    pc.printf( "\r\n");
    pc.printf( "\r\n");
    pc.printf( "************\r\n");
    pc.printf( "* LED Ctrl *\r\n");
    pc.printf( "*          *\r\n");
    pc.printf( "* U = up   *\r\n");
    pc.printf( "* D = down *\r\n");
    pc.printf( "*          *\r\n");
    pc.printf( "************\r\n");
    pc.printf( "\r\n");
    pc.printf( "$ ");

    while (1) {
        if(pc.readable()) {
            char c = pc.getc();

            // RX Command -> LIMIT Param -> PUT Led
            //
            if( (c == 'u') && (brightness<0.5) ) {
                brightness += 0.01;
                led = brightness;
                pc.printf( "up\r\n$ ");
            } else if( (c == 'd') && (brightness>0.0) ) {
                brightness -= 0.01 ;
                led = brightness;
                pc.printf( "down\r\n$ ");
            } else {
                /* nop */
                pc.printf( "\r\n$ ");
            }
        }

        // Wait & Blink Led
        //
        wait(0.1);
        activity =! activity;
    }
}
