#include "mbed.h"

AnalogIn sw(dp9);

Ticker timer;
PwmOut speaker(dp1);
Ticker envelope;
PwmOut env(dp2);
static int tms_per10=0; 

void env_out(void){
    float attack_ms =10;
    float decay_ms = 10;
    float sustain_ms = 20;
    float sustain = 0.2;
    float release_ms = 5000;

    float out_level;
    tms_per10++;
    if (tms_per10 > (attack_ms + decay_ms + sustain_ms + release_ms) * 10){
        env.write(0.0f);
    }else if(tms_per10 > (attack_ms + decay_ms + sustain_ms) * 10){
        out_level = sustain/(tms_per10 - (attack_ms + decay_ms + sustain_ms)) * release_ms; 
        env.write(out_level);
    }else if(tms_per10 > (attack_ms + decay_ms) * 10){
        env.write(sustain);
    }else if(tms_per10 > attack_ms * 10){
        env.write(1.0f);
    }else{
        out_level = 1.0f/attack_ms * tms_per10;
        env.write(out_level);
    }
}

void sound_out(void){
    speaker.write(((float)rand()/RAND_MAX));
}

     
int main()
{
//    sw.mode(PullUp);
    while(1){
        if (sw >= 0.3f){
            tms_per10=0; 
            speaker.period_us(10);
            env.period_us(10);
            timer.attach_us(&sound_out,100); //10kHz
            envelope.attach_us(&env_out,100); //10kHz
//            wait(1.0f);
        }
    wait(0.01f);
    }
}