//MQTT+WIFI


#define logMessage printf
#define MQTTCLIENT_QOS2 1

#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

int arrivedcount = 0;
//


#include "mbed.h"
#include "TCPSocket.h"
#include "VL53L1X.h"
#include <string> 
#define WIFI_IDW0XX1    2

#if (defined(TARGET_DISCO_L475VG_IOT01A) || defined(TARGET_DISCO_F413ZH))
#include "ISM43362Interface.h"
ISM43362Interface wifi(MBED_CONF_APP_WIFI_SPI_MOSI, MBED_CONF_APP_WIFI_SPI_MISO, MBED_CONF_APP_WIFI_SPI_SCLK, MBED_CONF_APP_WIFI_SPI_NSS, MBED_CONF_APP_WIFI_RESET, MBED_CONF_APP_WIFI_DATAREADY, MBED_CONF_APP_WIFI_WAKEUP, false);

#else // External WiFi modules

#if MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1
#include "SpwfSAInterface.h"
SpwfSAInterface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#endif // MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1

#endif


void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    logMessage("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    logMessage("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    //++arrivedcount;
}


const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    int count = wifi->scan(NULL,0);
    printf("%d networks available.\n", count);

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    for (int i = 0; i < count; i++)
    {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }

    delete[] ap;
    return count;
}

void http_demo(NetworkInterface *net)
{
    TCPSocket socket;
    nsapi_error_t response;

    printf("Sending HTTP request to www.arm.com...\n");

    // Open a socket on the network interface, and create a TCP connection to www.arm.com
    socket.open(net);
    response = socket.connect("www.arm.com", 80);
    if(0 != response) {
        printf("Error connecting: %d\n", response);
        socket.close();
        return;
    }

    // Send a simple http request
    char sbuffer[] = "GET / HTTP/1.1\r\nHost: www.arm.com\r\n\r\n";
    nsapi_size_t size = strlen(sbuffer);
    response = 0;
    while(size)
    {
        response = socket.send(sbuffer+response, size);
        if (response < 0) {
            printf("Error sending data: %d\n", response);
            socket.close();
            return;
        } else {
            size -= response;
            // Check if entire message was sent or not
            printf("sent %d [%.*s]\n", response, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
        }
    }

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    response = socket.recv(rbuffer, sizeof rbuffer);
    if (response < 0) {
        printf("Error receiving data: %d\n", response);
    } else {
        printf("recv %d [%.*s]\n", response, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
    }

    // Close the socket to return its memory and bring down the network interface
    socket.close();
}
bool s1_init = true;
bool s2_init = true;
bool s3_init = true;
bool s4_init = true;
VL53L1X sensor1(PC_1,PC_0, PC_2);
VL53L1X sensor2(PC_1,PC_0, PC_3);
VL53L1X sensor3(PC_1,PC_0, PC_4);
VL53L1X sensor4(PC_1,PC_0, PC_5);
SPI acc (PA_7,PA_6,PA_5);
DigitalOut cs(PB_8);
char buffer[6];
int16_t data[3];
float x,y,z,w;
Timer t; 
AnalogIn analog_value1(PA_2);
AnalogIn analog_value2(PA_4);
AnalogIn analog_value3(PB_1);
AnalogIn analog_value4(PA_3);
AnalogIn analog_value5(PB_0);
Serial pc(USBTX,USBRX);

void sensor(void)
{
     double meas_a;
     double meas_a1;
     double meas_b;
     double meas_b1;
     double meas_c;
     double meas_c1;
     double meas_d;
     double meas_d1;
     double meas_e;
     double meas_e1;
     double outputv;
     
     double D1;    
     double D2;  
     double D3;  
     double D4;  
     
     
     
     
    sensor1.initReading(0x52,50000);
    sensor2.initReading(0x27,50000);
    sensor3.initReading(0x35,50000);
    sensor4.initReading(0x37,50000);
     sensor1.setDistanceMode(VL53L1X::Short);
     sensor2.setDistanceMode(VL53L1X::Short);
     sensor3.setDistanceMode(VL53L1X::Short);
     sensor4.setDistanceMode(VL53L1X::Short);
     cs=1;
     acc.format(8,3);
     acc.frequency(2000000);
     cs=0;
     acc.write(0x31);
     acc.write(0x0B);
     cs=1;
     cs=0;
     acc.write(0x2D);
     acc.write(0x08);
     cs=1;
        
       D1 = sensor1.readFromOneSensor();
       wait(0.1);
       D2 = sensor2.readFromOneSensor();
       wait(0.1);
       D3 = sensor3.readFromOneSensor();
       wait(0.1);
       D4 = sensor4.readFromOneSensor();
       wait(0.1);
      
      cs=0;
      acc.write(0x80|0x40|0x32);
      for (int i=0;i<=5;i++)
      {
      buffer[i]=acc.write(0x00);
      }
      cs= 1;   
      data[0]=buffer[1]<<8|buffer[0];
      data[1]=buffer[3]<<8|buffer[2];
      data[2]=buffer[5]<<8|buffer[4];
      x=0.004*data[0];
      wait(0.1);
      y=0.004*data[1];
      wait(0.1);
      z=0.004*data[2];
      wait(0.1);
      w=atan2(x,y)*(57.4);
      wait(0.1);
      meas_a = analog_value1.read(); 
      meas_a1 = meas_a * 3*25; 
      meas_b = analog_value2.read(); 
      meas_b1 = meas_b * 3*25; 
      meas_c = analog_value3.read(); 
      meas_c1 = meas_c * 3*25; 
      meas_d = analog_value4.read(); 
      meas_d1 = meas_d * 3*25; 
      meas_e = analog_value5.read(); 
      meas_e1 = meas_e * 3*25; 
      
      
    
    
    }


int main()
{      

                   
    pc.baud (115200) ;
     
     double meas_a;
     double meas_a1;
     double meas_b;
     double meas_b1;
     double meas_c;
     double meas_c1;
     double meas_d;
     double meas_d1;
     double meas_e;
     double meas_e1;
     double outputv;
     
     double D1;    
     double D2;  
     double D3;  
     double D4;  
     
     
     
     
    sensor1.initReading(0x52,50000);
    sensor2.initReading(0x27,50000);
    sensor3.initReading(0x35,50000);
    sensor4.initReading(0x37,50000);
     sensor1.setDistanceMode(VL53L1X::Short);
     sensor2.setDistanceMode(VL53L1X::Short);
     sensor3.setDistanceMode(VL53L1X::Short);
     sensor4.setDistanceMode(VL53L1X::Short);
     cs=1;
     acc.format(8,3);
     acc.frequency(2000000);
     cs=0;
     acc.write(0x31);
     acc.write(0x0B);
     cs=1;
     cs=0;
     acc.write(0x2D);
     acc.write(0x08);
     cs=1;
        
       D1 = sensor1.readFromOneSensor();
       wait(0.1);
       D2 = sensor2.readFromOneSensor();
       wait(0.1);
       D3 = sensor3.readFromOneSensor();
       wait(0.1);
       D4 = sensor4.readFromOneSensor();
       wait(0.1);
      
      cs=0;
      acc.write(0x80|0x40|0x32);
      for (int i=0;i<=5;i++)
      {
      buffer[i]=acc.write(0x00);
      }
      cs= 1;   
      data[0]=buffer[1]<<8|buffer[0];
      data[1]=buffer[3]<<8|buffer[2];
      data[2]=buffer[5]<<8|buffer[4];
      x=0.004*data[0];
      wait(0.1);
      y=0.004*data[1];
      wait(0.1);
      z=0.004*data[2];
      wait(0.1);
      w=atan2(x,y)*(57.4);
      wait(0.1);
      meas_a = analog_value1.read(); 
      meas_a1 = meas_a * 3*25; 
      meas_b = analog_value2.read(); 
      meas_b1 = meas_b * 3*25; 
      meas_c = analog_value3.read(); 
      meas_c1 = meas_c * 3*25; 
      meas_d = analog_value4.read(); 
      meas_d1 = meas_d * 3*25; 
      meas_e = analog_value5.read(); 
      meas_e1 = meas_e * 3*25;  
     
         
                     
    int count = 0;

    printf("WiFi example\n\n");

    count = scan_demo(&wifi);
    
    if (count == 0) {
        printf("No WIFI APNs found - can't continue further.\n");
        return -1;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    //int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA);
    if (ret != 0) {
        printf("\nConnection error\n");
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi.get_mac_address());
    printf("IP: %s\n", wifi.get_ip_address());
    printf("Netmask: %s\n", wifi.get_netmask());
    printf("Gateway: %s\n", wifi.get_gateway());
    printf("RSSI: %d\n\n", wifi.get_rssi());

    http_demo(&wifi);

    //wifi.disconnect();

    printf("\Wifi Example Done,MQTT Example Start\n");
    
    // MQTT Example Start
    float version = 0.6;
    char* topic = "192.168.0.164";

    logMessage("HelloMQTT: version is %.2f\r\n", version);

    NetworkInterface* network = &wifi;
    if (!network) {
        return -1;
    }

    MQTTNetwork mqttNetwork(network);

    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);

    const char* hostname = "192.168.0.164";
    int port = 1883;
    logMessage("Connecting to %s:%d\r\n", hostname, port);
    int rc = mqttNetwork.connect(hostname, port);
    if (rc != 0)
        logMessage("rc from TCP connect is %d\r\n", rc);

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-sample";
    data.username.cstring = "testuser";
    data.password.cstring = "testpassword";
    if ((rc = client.connect(data)) != 0)
        logMessage("rc from MQTT connect is %d\r\n", rc);

    if ((rc = client.subscribe(topic, MQTT::QOS2, messageArrived)) != 0)
        logMessage("rc from MQTT subscribe is %d\r\n", rc);
    
    MQTT::Message message;
    //pc.printf("%d,%d,%d,%d,%+1.2f,%+1.2f,%+1.2f,%+1.2f,%1.0f,%1.0f,%1.0f,%1.0f,%1.0f\n\r", 
//sensor1.readFromOneSensor(), sensor2.readFromOneSensor(), sensor3.readFromOneSensor(), sensor4.readFromOneSensor(),
//x,y,z,w, meas_a1, meas_b1, meas_c1, meas_d1, meas_e1);
    // QoS 0
      
    char buf[100];
     sprintf(buf, "100");
     
     
      //sprintf(buf, "%d,%d,%d,%d,%+1.2f,%+1.2f,%+1.2f,%+1.2f,%1.0f,%1.0f,%1.0f,%1.0f,%1.0f\n\r", 
//sensor1.readFromOneSensor(), sensor2.readFromOneSensor(), sensor3.readFromOneSensor(), sensor4.readFromOneSensor(),
//x,y,z,w, meas_a1, meas_b1, meas_c1, meas_d1, meas_e1);



    message.qos = MQTT::QOS1;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    client.yield(100);
 
 
 
       
   
}
