#include "mbed.h"

//Setup a new class for Grove_temp_sensor sensor
class Grove_temp_sensor
{
public:
     /**  Read the servo motors current position
     *
     * @param returns A normalised number 0.0-1.0  representing the full range.
     */
    Grove_temp_sensor(PinName pin);
     /**  Read the servo motors current position
     *
     * @param returns A normalised number 0.0-1.0  representing the full range.
     */
    Grove_temp_sensor();
     /**  Read the servo motors current position
     *
     * @param returns A normalised number 0.0-1.0  representing the full range.
     */
    float read();
private:
//class sets up the AnalogIn pin
    AnalogIn _pin;
};

Grove_temp_sensor::Grove_temp_sensor(PinName pin) : _pin(pin)
{
// _pin(pin) means pass pin to the AnalogIn constructor
}

float Grove_temp_sensor::read()
{

        double a;
        a=_pin.read()*1023;
        double resistance=(float)(1023-a)*10000/a;
        double temperature=1/(log(resistance/10000)/3975+1/298.15)-276.05;
        //conver C to F;
        temperature = (9.0*temperature)/5.0 + 32.0;
    return temperature;
}


        