/*
 * mbed_osc.h
 *
 *  Created on: Mar 8, 2010
 *      Author: pehr
 *     The functions to control the mBed using OSC
 *     This includes setting up the UDP and  OSC subsystem
 *     And registering handlers to control mBed I/O
 */
/*********************************************************************************

 Copyright 2006-2009 MakingThings

 Licensed under the Apache License,
 Version 2.0 (the "License"); you may not use this file except in compliance
 with the License. You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed
 under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 CONDITIONS OF ANY KIND, either express or implied. See the License for
 the specific language governing permissions and limitations under the License.

*********************************************************************************/
#ifndef MBED_OSC_H_
#define MBED_OSC_H_

#define UDP_RECV_PORT 4444
#define UDP_BROADCAST_PORT 5555

#include "mbed.h"
#include "osc_sys.h"

#include "lwip/udp.h"

#include "NetServer.h"

#include "ipv4/lwip/ip_addr.h"


NetServer * getNetServer(); //get the netserver to do things like get hostname
char * getScratch();
struct udp_pcb * getUdpPcb();


void osc_sendIPBroadcast();
int osc_init();
void osc_poll();

void udp_recv_callback(void *arg, struct udp_pcb *upcb, struct pbuf *p, struct ip_addr *addr, u16_t port);





#endif /* MBED_OSC_H_ */
