/*
 * Pehr Hovey
 *
 * mBed OSC - IoOsc subsystem
 * Get/set info about the system like ip address, hostname
 * Based on code from Make Controller
 */
/*********************************************************************************

 Copyright 2006-2009 MakingThings

 Licensed under the Apache License,
 Version 2.0 (the "License"); you may not use this file except in compliance
 with the License. You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed
 under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 CONDITIONS OF ANY KIND, either express or implied. See the License for
 the specific language governing permissions and limitations under the License.

*********************************************************************************/

#include "mbed_io_osc.h"
#include "osc_sys.h"
#include "mbed.h"


static char* IoOsc_Name = "io"; //the OSC container for this address
static char* IoOsc_PropertyNames[] = { "active", "value",
                                            0 }; // must have a trailing 0



const char* IoOsc_GetName( void )
{
  return IoOsc_Name;
}
// Now getting a message.  This is actually a part message, with the first
// part (the subsystem) already parsed off.
int IoOsc_ReceiveMessage( int channel, char* message, int length )
{
  //printf("IoOsc Receive: message is %s\r\n",message);
	int status = Osc_IndexIntReceiverHelper( channel, message, length,
                                     IO_CHANNELS,IoOsc_validIndex, IoOsc_Name,
                                     IoOsc_PropertySet, IoOsc_PropertyGet,
                                     IoOsc_PropertyNames );
  if ( status != CONTROLLER_OK ){
   //printf("IoOsc Receive error status = %d\r\n",status);
	  return Osc_SendError( channel, IoOsc_Name, status );
  }
  return CONTROLLER_OK;

}


int IoOsc_PropertySet( int index, int property, int value )
{
  printf("IoOsc SET index=%d prop=%d val=%d\r\n",index,property,value);
	switch ( property )
  {
    case 0: //active
   //   Led_SetActive( index, value );
      //Set if the pin is on or not
      break;
    case 1: //value on-off
    	//printf("Setting LED index=%d to value=%d\r\n",index,value);
    	return Io_SetValue(index,value);
      break;
  }
  return CONTROLLER_OK;
}

//Retrieve a value which will be sent back by the receiverhelper
int IoOsc_PropertyGet( int index, int property )
{
  int value = 0;

  switch ( property )
  {
    case 0: //is it active?
      //value = Led_GetActive( index );

      break;
    case 1: // is it on or off?
     // printf("Getting value for LED index=%d \r\n",index);
      value = Io_GetValue( index );

      break;

  }
 // printf("IoOsc GET index=%d prop=%d val=%d\r\n",index,value);
  return value;
}



//DigitalInOut D5(p5); // also broadcast test button
//DigitalInOut D6(p6);
//DigitalInOut D7(p7);
//DigitalInOut D8(p8);
//DigitalInOut D9(p9);
//DigitalInOut D10(p10);
//DigitalInOut D11(p11);
//DigitalInOut D12(p12);
//DigitalInOut D13(p13);
//DigitalInOut D14(p14);

DigitalOut D6(p6); //just make then Out for now
DigitalOut D7(p7);
DigitalOut D8(p8);
DigitalOut D9(p9);
DigitalOut D10(p10);
DigitalOut D11(p11);
DigitalOut D12(p12);
DigitalOut D13(p13);
DigitalOut D14(p14);


//Only certain pin indexes are allowed
bool IoOsc_validIndex(int index){
	return ((index > 5 && index <=14) ||
			(index >= 27 && index <=30)); //21-26 are PWM so exclude
}
//Set the actual pin
int Io_SetValue(int index, int value){
	if(value > 1)
			value = 1;
		if(value < 0)
			value = 0;
	if(IoOsc_validIndex(index)){
		switch(index){
			case 6:
				D6 = value;
			break;
			case 7:
				D7 = value;
			break;
			case 8:
				D8 = value;
			break;
			case 9:
				D9 = value;
			break;
			case 10:
				D10 = value;
			break;
			case 11:
				D11 = value;
			break;
			case 12:
				D12 = value;
			break;
			case 13:
				D13 = value;
			break;
			case 14:
				D14 = value;
			break;
			}
		return CONTROLLER_OK;
	}else{
		return CONTROLLER_ERROR_ILLEGAL_INDEX;
	}

}
int Io_GetValue(int index){
	return 0;
}

/*** Control the four onboard LEDs ***/

//do LEDs here  for now

DigitalOut L1(LED1);
DigitalOut L2(LED2);
DigitalOut L3(LED3);
DigitalOut L4(LED4);

int Led_SetValue(int index, int value){
	if(value > 1)
		value = 1;
	if(value < 0)
		value = 0;

	if(index >= 0 && index < 4){
		switch(index){
		case 0:
			L1 = value;
		break;
		case 1:
			L2 = value;
		break;
		case 2:
			L3 = value;
		break;
		case 3:
			L4 = value;
		break;
		}
		return CONTROLLER_OK;
	}else{

			return CONTROLLER_ERROR_ILLEGAL_INDEX;

	}
}
int Led_GetValue(int index){
	int val = -1;

	if(index >= 0 && index < 4){
		switch(index){
		case 0:
			val = L1.read();
		break;
		case 1:
			val = L2.read();
		break;
		case 2:
			val = L3.read();
		break;
		case 3:
			val = L4.read();
		break;
		}
		return val;
	}else{

			return CONTROLLER_ERROR_ILLEGAL_INDEX;
		}
}

// Need a list of property names
// MUST end in zero
static char* LedOsc_Name = "led";
static char* LedOsc_PropertyNames[] = { "active", "value", 0 }; // must have a trailing 0


// Returns the name of the subsystem
const char* LedOsc_GetName( )
{
  return LedOsc_Name;
}

// Now getting a message.  This is actually a part message, with the first
// part (the subsystem) already parsed off.
int LedOsc_ReceiveMessage( int channel, char* message, int length )
{
  //printf("LedOsc Receive: message is %s\r\n",message);
	int status = Osc_IndexIntReceiverHelper( channel, message, length,
                                     LED_CHANNELS, NULL,LedOsc_Name,
                                     LedOsc_PropertySet, LedOsc_PropertyGet,
                                     LedOsc_PropertyNames );
  if ( status != CONTROLLER_OK ){
   //printf("LedOsc Receive error status = %d\r\n",status);
	  return Osc_SendError( channel, LedOsc_Name, status );
  }
  return CONTROLLER_OK;

}


int LedOsc_PropertySet( int index, int property, int value )
{
  printf("LedOsc SET index=%d prop=%d val=%d\r\n",index,property,value);
	switch ( property )
  {
    case 0: //active
   //   Led_SetActive( index, value );
      //Set if the pin is on or not
      break;
    case 1: //value on-off
    	//printf("Setting LED index=%d to value=%d\r\n",index,value);
    	return Led_SetValue(index,value);
      break;
  }
  return CONTROLLER_OK;
}

//Retrieve a value which will be sent back by the receiverhelper
int LedOsc_PropertyGet( int index, int property )
{
  int value = 0;

  switch ( property )
  {
    case 0: //is it active?
      //value = Led_GetActive( index );

      break;
    case 1: // is it on or off?
     // printf("Getting value for LED index=%d \r\n",index);
      value = Led_GetValue( index );

      break;

  }
 // printf("LedOsc GET index=%d prop=%d val=%d\r\n",index,value);
  return value;
}

