/*
 * Pehr Hovey
 *
 * mBed OSC - SystemOsc subsystem
 * Get/set info about the system like ip address, hostname
 * Based on code from Make Controller
 */
/*********************************************************************************

 Copyright 2006-2009 MakingThings

 Licensed under the Apache License,
 Version 2.0 (the "License"); you may not use this file except in compliance
 with the License. You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed
 under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 CONDITIONS OF ANY KIND, either express or implied. See the License for
 the specific language governing permissions and limitations under the License.

*********************************************************************************/

#include "mbed_system_osc.h"
#include "osc_sys.h"
#include "mbed_osc.h" //to get the netserver
#include "mbed.h"

static char* SystemOsc_Name = "system"; //the OSC container for this address
static char* SystemOsc_PropertyNames[] = { "serialnumber", "version","name", "ipinfo", "mac","hostname",
                                            0 }; // must have a trailing 0

int SystemOsc_PropertySet( int property, char* typedata, int channel );
int SystemOsc_PropertyGet( int property, int channel );

const char* SystemOsc_GetName( void )
{
  return SystemOsc_Name;
}
// need to allow this to accept non-int arguments
int SystemOsc_ReceiveMessage( int channel, char* message, int length )
{
  //printf("SystemOsc received a message: %s\r\n",message);
	int status = Osc_GeneralReceiverHelper( channel, message, length,
                                SystemOsc_Name,
                                SystemOsc_PropertySet, SystemOsc_PropertyGet,
                                SystemOsc_PropertyNames );

  if ( status != CONTROLLER_OK ){
	  printf("SystemOsc error, status is: %d\r\n",status);
	  return Osc_SendError( channel, SystemOsc_Name, status );
  }

  return CONTROLLER_OK;
}

int SystemOsc_Poll( )
{
  return CONTROLLER_OK;
}

// Set the index'd property, property with the value
//Not everything can be set
int SystemOsc_PropertySet( int property, char* typedata, int channel )
{
	//printf("SysOSC property SET: %d data: %s\r\n",property, typedata);
	int value = 0;
  switch ( property )
  {

    case 0: // serialnumber
    {
      int count = Osc_ExtractData( typedata, "i", &value );
      if ( count != 1 )
        return Osc_SubsystemError( channel, SystemOsc_Name, "Incorrect data - need an int" );

      //nothing yet System_SetSerialNumber( value );
      break;
    }
    case 1: //version
    {

    	break;
    }
    case 2: // name
    {
      int count = Osc_ExtractData( typedata, "s", &value );
      if ( count != 1 )
        return Osc_SubsystemError( channel, SystemOsc_Name, "Incorrect data - need a string" );

      break;
    }
    case 5: //hostname
    {
    	char *newname;
    	int count = Osc_ExtractData( typedata, "s", &newname );
    	if ( count != 1 )
    	        return Osc_SubsystemError( channel, SystemOsc_Name, "Incorrect data - need a string" );
    	NetServer * net = getNetServer();
    	net->setHostname(newname);
    	break;
    }

  }
  return CONTROLLER_OK;
}
//A hack, from mbed forums, to  get MAC adress directly
//This is useful since the NetServer doesnt seem to give direct access to the netif to get it
extern "C" void mbed_mac_address(char *mac);

// Get the value of a property
int SystemOsc_PropertyGet( int property, int channel )
{
	//printf("SysOSC property GET: %d\r\n",property);
	int value = 0;
	char * oscaddr =  getScratch(); //a reserved scratch space
	//Construct the return OSC-address
	 snprintf( oscaddr, OSC_SCRATCH_SIZE, "/%s/%s", SystemOsc_Name, SystemOsc_PropertyNames[ property ] );
  switch ( property )
  {
    case 0: // serialnumber
      value = 12345;//hardcoded for now

      Osc_CreateMessage( channel, oscaddr, ",i", value );
      break;
    case 1: // version
    {
      char versionString[50];
      snprintf(versionString, 50, "%s",MBED_LIBRARY_VERSION);

      Osc_CreateMessage( channel, oscaddr, ",s", versionString );
      break;
    }

    case 3: // ipinfo
    {
    	NetServer * net = getNetServer();
    	struct ip_addr  ipaddr = net->getIPAddr();

		char ipstring[25];
		snprintf(ipstring, 25,"%hhu.%hhu.%hhu.%hhu", (ipaddr.addr)&0xFF, (ipaddr.addr>>8)&0xFF, (ipaddr.addr>>16)&0xFF, (ipaddr.addr>>24)&0xFF);

    	int port = UDP_RECV_PORT; //where is it listening?

    	//snprintf( oscaddr, OSC_SCRATCH_SIZE, "/%s/%s", SystemOsc_Name, SystemOsc_PropertyNames[ property ] );
    	 int rval = Osc_CreateMessage( channel, oscaddr, ",si", ipstring,port );

      break;
    }
    case 4: // mac (MAC address of ethernet port)
    	char mac[6];

    	mbed_mac_address(mac); // update mac to the unique mbed mac address

    	char mac_str[50];

    	snprintf(mac_str,50,"%02x:%02x:%02x:%02x:%02x:%02x",
    	        (char*) mac[0],
    	        (char*) mac[1],
    	        (char*) mac[2],
    	        (char*) mac[3],
    	        (char*) mac[4],
    	        (char*) mac[5]);


      Osc_CreateMessage( channel, oscaddr, ",s", mac_str );
      break;
    case 2: // name (same as hostname for now)
    case 5: // hostname
    {
    	NetServer * net = getNetServer();
    const char * hname = net->getHostname();

    Osc_CreateMessage( channel, oscaddr, ",s", hname );
      break;
    }

  }

  return CONTROLLER_OK;
}



