/*
 * Pehr Hovey
 *
 * mBed OSC - IoOsc subsystem
 * Get/set digital output pins
 * Based on code from Make Controller
 */
 /*********************************************************************************

 Copyright 2006-2009 MakingThings

 Licensed under the Apache License,
 Version 2.0 (the "License"); you may not use this file except in compliance
 with the License. You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed
 under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 CONDITIONS OF ANY KIND, either express or implied. See the License for
 the specific language governing permissions and limitations under the License.

*********************************************************************************/
#ifndef MBED_IO_OSC_
#define MBED_IO_OSC_
//OSC Subsystems

#define IO_CHANNELS 14 //start with 8
// Regular digital I/O
int IoOsc_ReceiveMessage( int channel, char* message, int length );
const char* IoOsc_GetName( void );
int IoOsc_PropertySet(  int index, int property, int value );
int IoOsc_ReceiveMessage( int channel, char* message, int length );
int IoOsc_PropertyGet( int property, int channel );
bool IoOsc_validIndex(int index);


//Get/set digital IO
int Io_SetValue(int index, int value);
int Io_GetValue(int index);
void Io_SetMode(int index, int mode); //in or out

//four onboard LEDs - on or off

#define LED_CHANNELS 4
//Get/set LEDs
int Led_SetValue(int index, int value);
int Led_GetValue(int index);

int LedOsc_ReceiveMessage( int channel, char* message, int length );
const char* LedOsc_GetName( void );
int LedOsc_PropertySet(  int index, int property, int value );
int LedOsc_ReceiveMessage( int channel, char* message, int length );
int LedOsc_PropertyGet( int property, int channel );
#endif
