/* Pehr Hovey
   Tests with UDP for mBed
 */

#include "mbed.h"
#include "lwip/init.h"
#include "lwip/opt.h"
#include "lwip/udp.h"


 
#include "NetServer.h"

#include "ipv4/lwip/ip_addr.h"

int send_test = 0; //toggled by button

 struct udp_pcb *pcb;

InterruptIn button(p8);

DigitalOut got_udp(LED1);

DigitalOut sent_udp(LED4);

//callback for button interrupt
void sendBroadcast(){
         //broadcast something
          struct pbuf *p;
        char msg[]="testing mBedUDP";
        p = pbuf_alloc(PBUF_TRANSPORT,sizeof(msg),PBUF_RAM);
        memcpy (p->payload, msg, sizeof(msg));
        err_t res = udp_sendto(pcb, p, IP_ADDR_BROADCAST, 5555); //broadcast test msg
        pbuf_free(p); //De-allocate packet buffer
        printf("Sent test message to port 1234, result is %d Waiting...\r\n",res);
}

//Send arbitrary data
static void udp_send_something(char msg[], struct udp_pcb *upcb, struct ip_addr *addr, u16_t port)
{
    printf("Sending message to port %d: %s\r\n",port,msg);
    sent_udp = 1;
    int psize = 40; //pick a size for now...
      struct pbuf *q;
        q = pbuf_alloc(PBUF_TRANSPORT,psize, PBUF_RAM);
      printf("Making packet with size %d\r\n",psize);
     if (q != NULL) {
        sent_udp = 1;
            q->payload = msg; //Assign the string pointer
          
            err_t code;
            /* send UDP response to IP addr and port specified */
          code = udp_sendto(upcb, q, IP_ADDR_BROADCAST, port);
            printf("Sent, result code is %d\r\n",code);
            /* free the "reference" pbuf */
            pbuf_free(q);
      }else{
      printf("Could not allocate packet buffer!\r\n");
      }
    sent_udp = 0;
}

/**UDP recv callback */
static void udp_test_recv(void *arg, struct udp_pcb *upcb, struct pbuf *p, struct ip_addr *addr, u16_t port)
{
   printf("Received UDP Packet on port %d\r\n",port);
  // printf("Received UDP Packet from ip_addr %s\r\n",  inet_ntoa(*(struct in_addr*)&(ip_addr)));
  LWIP_UNUSED_ARG(arg);
   got_udp = 1;
  /* if packet is valid */
  if (p != NULL) {
    //Try to print out what we received
    printf("UDP Packet Received! Payload:\r\n");
    printf("-- %s --\r\n",static_cast<char *>(p->payload));
   err_t code = udp_sendto(upcb, p, IP_ADDR_BROADCAST, 5555); //send it back to port 5555
     printf("Echo'd packet, result code is %d\r\n",code);

    
    /* free the pbuf */
    pbuf_free(p);
    got_udp=0;
    sent_udp=0;
  }
}


int main() {
  //Attach interrupt to the button to send packet on press
  button.rise(&sendBroadcast);
  
   /*Initialize NetServer which gets us our DHCP address and
    gets the network interface ready
    */
   NetServer *net = NetServer::ready();
  
 
   //Initialize UDP
 
    pcb = udp_new();
   
   
    
  if (pcb != NULL) {
    /* we have to be allowed to send broadcast packets! */
    pcb->so_options |= SOF_BROADCAST;
    udp_bind(pcb, IP_ADDR_ANY, 4444); //Receive from any IP address, on the specified port
    udp_recv(pcb,udp_test_recv, NULL);
  }else{
  printf("Could not make UDP pcb\r\n");
  }
   
  
 net->waitUntilReady(); //this will print IP
 net->setHostname("chapala");
   
   //Send a startup packet
    printf("UDP Tester started...\r\n");
    
    while(1) {
        net->poll();
        
    
    }
}
