#include "mbed.h"
//  Expanding the TIMER function to allow timing to very long times 
// Demo written for lpc1768 to compare to onboard realtime clock.
// uses highusecs to encode the top 32 bits of the timer output
// and an int to uint conversion to get rid of the annoying negative.

Timer t;

 
int main() {
set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
float umax=0,seconds=0;
unsigned int realusecs=0,oldusecs=0,highusecs=0,minutes=0;;
int dtime,usecs=0;

    t.start();
    usecs=t.read_us();
    realusecs=(unsigned int)usecs;
    time_t rtcstart = time(NULL);
    printf("\n\n\r");
    while(1)
    {
    wait(1);
    oldusecs=realusecs;
    usecs=t.read_us();
    realusecs=(unsigned int)usecs;
    //if(realusecs==0) t.reset(); // timer counts back up to 0 and finishes there
   if(realusecs<oldusecs) { // its rolled over
    highusecs++; // increment highbyte
   }
   seconds=((float)realusecs/1000000.0)+4294.967296*(float)highusecs;
   minutes=(int)(seconds/60);
    
    if(umax<realusecs) umax=realusecs;
    time_t rtcsecs = time(NULL);
    dtime=rtcsecs-rtcstart;
    printf("Seconds=%6.2f  mins=%d   realus=%u     hus=%u     us=%d       rtcs=%d         oldusecs=%u          \r",seconds,minutes,realusecs,highusecs,usecs,dtime,oldusecs);
   
    }

    
}
