/*
MultiClick.h:
  For one button operation.
  This library suports these events,
    * Single click
    * Double click
    * N times click (over 3 times click)
    * Long press

The MIT License (MIT)

Copyright (c) 2016 Uematsu Electric Co.,Ltd. Toru OHTSUKA
<t-ohtsuka@jupiter.ocn.ne.jp>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/*
 * Modified version to work with an EventQueue
 * Removed deprecated code
 */

#include "mbed.h"

class MultiClick {
public:
  MultiClick(PinName pin, EventQueue *q);
  MultiClick(PinName pin, PinMode m, EventQueue *q);
  void attach_clicked(void (*function)(void));
  void attach_doubleclicked(void (*function)(void));
  void attach_n_clicked(void (*function)(int));
  void attach_longpressed(void (*function)(void));

private:
  void isr_pressed(void);
  void click_detect_timeout(void);
  void press_check_func(void);

  InterruptIn *_iin;
  PinMode _mode;

  Ticker *_press_check;
  Timeout *_click_detect_timeout;

  int _shortpress_num;
  int _longpress_num;

  int _press_check_interval_us;
  int _click_interval_us;
  int _click_times;

  int _pressed_count;
  bool _longpressed;

  EventQueue *_queue;

  void (*_c_callback_clicked)(void);
  void (*_c_callback_doubleclicked)(void);
  void (*_c_callback_n_clicked)(int);
  void (*_c_callback_longpressed)(void);
};
