// Code from TNode/TGateway @ Anarduino.com
// NOTE: code sample was inspired from ideas gained from: https://github.com/aanon4/RFM69
//
// Sender - periodically send time(millis), radio temperature, RSSI to listener...
// 2014 - anarduino.com
//
#include "RFM69.h"
#include "mbed.h"

#define GATEWAY_ID    1
#define NODE_ID       41    // node ID
#define NETWORKID     101    //the same on all nodes that talk to each other
#define MSG_INTERVAL  100

// Uncomment only one of the following three to match radio frequency
//#define FREQUENCY     RF69_433MHZ    
//#define FREQUENCY     RF69_868MHZ
#define FREQUENCY     RF69_915MHZ

#define IS_RFM69HW   //NOTE: uncomment this ONLY for RFM69HW or RFM69HCW
#define ENCRYPT_KEY    "EncryptKey123456" 
#define ACK_TIME       50                  
#define LED            PC_13                   
#define SERIAL_BAUD    115200
#define VERSION  "1.0"

#define MSGBUFSIZE 64   

char msgBuf[MSGBUFSIZE];

Serial pc(PA_2, PA_3);
DigitalOut myled(PC_13);             //"Moteino Half Shield" has LED on D9
//RFM69::RFM69(PinName  PinName mosi, PinName miso, PinName sclk,slaveSelectPin, PinName int)
RFM69 radio(PB_15, PB_14, PB_13, PB_12, PA_8);

bool promiscuousMode = false; // set 'true' to sniff all packets on the same network
bool requestACK = false;
Timer tmr;

main() {
  memset(msgBuf,0,sizeof(msgBuf));
  int i=1;
  long l;
  tmr.start();

  pc.baud(SERIAL_BAUD);
  pc.printf("Sender %s startup at %d Mhz...\r\n",VERSION,(FREQUENCY==RF69_433MHZ ? 433 : FREQUENCY==RF69_868MHZ ? 868 : 915));
  wait(2);
  radio.initialize(FREQUENCY, NODE_ID, NETWORKID);
  radio.encrypt(0);
  radio.setPowerLevel(20);
  radio.promiscuous(promiscuousMode);
#ifdef IS_RFM69HW
  radio.setHighPower(); //uncomment #define ONLY if radio is of type: RFM69HW or RFM69HCW 
#endif
  msgBuf[0] = (uint8_t)NODE_ID;  // load NODEID

while(1) {
  uint8_t tempC =  radio.readTemperature(-1); // -1 = user cal factor, adjust for correct ambient
  uint8_t tempF = 1.8 * tempC + 32; // 9/5=1.8
 
  l = tmr.read_ms();  // load time

  sprintf((char*)msgBuf,"#%d, t=%Lu, temp=%dF, RSSI=%d ",i,l,tempF,radio.RSSI); 
   if(radio.sendWithRetry((uint8_t)GATEWAY_ID, msgBuf,strlen(msgBuf),true))
            pc.printf("Packet %d sent, Ack ok!\r\n",i++);
       else pc.printf("Packet %d sent, no Ack!\r\n",i++);
  wait_ms(MSG_INTERVAL);
  myled = !myled;
  }
}
