// Listener - print sender messages
// From Tnode/Tsender @ anarduino.com
// 2014 - anarduino.com
//
#include "mbed.h"
#include "RFM69.h"

#define NETWORK_ID          101
#define BOXRADIO_ID         69
#define NODE_ID             55
#define FREQUENCY_915MHZ    91

// Uncomment only one of the following three to match radio frequency
//#define FREQUENCY     RF69_433MHZ    
//#define FREQUENCY     RF69_868MHZ
#define FREQUENCY     RF69_915MHZ

#define IS_RFM69HW   //NOTE: uncomment this ONLY for RFM69HW or RFM69HCW
#define ENCRYPT_KEY    "EncryptKey123456"  // use same 16byte encryption key for all devices on net
#define ACK_TIME       50                  // max msec for ACK wait
#define LED            9                   // Anardino miniWireless has LEDs on D9
#define SERIAL_BAUD    115200
#define VERSION  "1.0"

#define MSGBUFSIZE 64   // message buffersize, but for this demo we only use: 
                        // 1-byte NODEID + 4-bytes for time + 1-byte for temp in C + 2-bytes for vcc(mV)

Serial pc(PA_9, PA_10);
DigitalOut myled(PC_13);
DigitalOut but(PA_1, PullUp);
//RFM69::RFM69(PinName  PinName mosi, PinName miso, PinName sclk,slaveSelectPin, PinName int)
RFM69 radio(PB_15, PB_14, PB_13, PB_12, PA_8);

bool promiscuousMode = false; // set 'true' to sniff all packets on the same network
uint8_t data[61];
bool requestACK=false;

Timer tmr;

main() {
  uint8_t theNodeID;
  tmr.start();

  pc.baud(SERIAL_BAUD);
  pc.printf("\r\nListener %s startup at %d Mhz...\r\n",VERSION,(FREQUENCY==RF69_433MHZ ? 433 : FREQUENCY==RF69_868MHZ ? 868 : 915));
  wait(1);
  radio.initialize(FREQUENCY, GATEWAY_ID, NETWORKID);
  radio.encrypt(0);
  radio.promiscuous(promiscuousMode);
  radio.setPowerLevel(20);
#ifdef IS_RFM69HW
  radio.setHighPower(); //uncomment #define ONLY if radio is of type: RFM69HW or RFM69HCW 
#endif

while(1) {
  if (radio.receiveDone()) {
     pc.printf("Received from TNODE: %d ",radio.SENDERID);
     pc.printf((char*)radio.DATA);
     if (radio.ACKRequested()){
        theNodeID = radio.SENDERID;
        radio.sendACK();
        pc.printf(" - ACK sent. Receive RSSI: %d\r\n",radio.RSSI);
     } else pc.printf("Receive RSSI: %d\r\n",radio.RSSI);
  }
         myled = !myled; 
 }
}