
#include "mbed.h"
//#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MMA8491Q.h"
//#include "MAG3110.h"
//#include "MPL3115A2.h"
#include <cstdlib>
#include <iostream>

#include <stdint.h>
#include "SDFileSystem.h"


#include "PCF8583_rtc.h"

I2C i2c(PTE0, PTE1);       // sda, scl
PCF8583rtc rtc(&i2c, PCF8583_addr_2);
SDFileSystem sd(PTD2, PTD3, PTD1, PTD5, "sd"); //PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name
/*                  DI , DO ,SCK , CS
MicroSD Breakout    mbed
   CS  o-------------o PTA13    (DigitalOut cs)
   DI  o-------------o PTD2    (SPI mosi)
   VCC o-------------o VOUT
   SCK o-------------o PTD1    (SPI sclk)
   GND o-------------o GND
   DO  o-------------o PTD3    (SPI miso)
   CD  o
   */


Serial se(PTE22, PTE23);
Serial pc(USBTX,USBRX);

MMA8451Q acc51(PTE25, PTE24, 0x1D<<1);
MMA8491Q acc91(PTE0, PTE1, 0x55<<1);
//MAG3110 mag(PTE0, PTE1, 0x0E<<1);
//MPL3115A2 mpl(PTE0, PTE1, 0x60<<1);

Timer t;
//PwmOut rled(LED_RED);

//DigitalOut rled(LED_RED); partilhado com sck não usar
//DigitalOut bled(LED_BLUE);
//DigitalOut gled(LED_GREEN);

//PwmOut gled(LED_GREEN);
//PwmOut bled(LED_BLUE);

DigitalOut enMMA8491(PTC7);

DigitalOut memok (PTB0); // azul ok
DigitalOut membad (PTB2); // vermelho
DigitalOut ejeok (PTB1); //verde

DigitalIn detect (PTD4);

InterruptIn eject (PTD7); //ejectar cartão

InterruptIn intMPL3115(PTA4);
InterruptIn intMAG3110(PTA5);

DigitalIn acc91X(PTC4);
DigitalIn acc91Y(PTC3);
DigitalIn acc91Z(PTC0);
DigitalIn lock(PTB3);

int flagject = 0;//flag eject

char X_buffer [5];

int set = 0;

int readSerialString ()
{

    int x = 0;
    int aux=0;
    for(aux=0; aux<5; aux++) {
        X_buffer[aux]=0;
    }
    /*j=0;
    while(j<5) {
        X_buffer[j] = pc.getc();
        j++;
    }*/
    se.scanf("%s",&X_buffer[0]);
    x=atoi(X_buffer);
    return x;
}


void clockset()
{
    /* wait (5);
     se.printf("clockset \n");*/
    int   hours=0;
    int   mins=0;

    int   sec=0;
    int   csec=0;

    int day=0;
    int month=0;
    int year=0;

    struct DateTime_t dt;
    //NVIC_DisableIRQ(UART2_IRQn);
    wait_ms (200);
    rtc.pauseCounting();

    se.printf("\nH?");
    hours=readSerialString ();
    dt.time.hours = rtc.bin2bcd(hours);

    se.printf("\nM?");
    mins=readSerialString ();
    dt.time.minutes= rtc.bin2bcd(mins);

    se.printf("\nS?");
    sec=readSerialString ();
    dt.time.seconds = rtc.bin2bcd(sec);

    se.printf("\nCS?");
    csec=readSerialString ();
    dt.time.hundreds = rtc.bin2bcd(csec);

    se.printf("\nDia?");
    day=readSerialString ();
    dt.date.day = rtc.bin2bcd(day);

    se.printf("\nMes?");
    month=readSerialString ();
    dt.date.month = rtc.bin2bcd(month);

    se.printf("\nAno?");
    year=readSerialString ();
    dt.date.year=rtc.bin2bcd(year);

    rtc.write(TIME, dt);

    // rtc.enableCounting();
    wait_ms(10);
    //NVIC_EnableIRQ(UART2_IRQn);
    se.printf("done");
    se.printf("\n");
    set=1;
}

void flip ()

{
    flagject =1;
}




int main()

{
    se.baud(9600);
    pc.baud(115200);

  
    memok=1;
    membad=1;
    ejeok = 1;


    struct DateTime_t dt;
    
    if(lock==0&&set==0) {
        membad=0;
        wait (10);
        se.printf("clockset \n");
        clockset();
        membad=1;
    }

    using namespace std;
    //  mkdir("/sd/xxdir", 0777);

    int hours=0;
    int mins=0;

    int sec=0;
    int csec=0;
    int day=0;
    int month=0;
    int year=0;

    char name[40];

    //  char acele[110];

    float flag=0;


//   float onTime = 1.0;
//   float offTime = 0.0;
    float holdTime = 1;
    bool on = true;
    bool off = false;
    int magX = 0, magY = 0, magZ = 0;
    float mplAlt = .0, mplPres = .0, mplTemp = .0;
   // mpl.Altimeter_Mode();

    /*
        dt.time.hours = rtc.bin2bcd(23);
        dt.time.minutes = rtc.bin2bcd(59);
        dt.time.seconds = rtc.bin2bcd(50);
        dt.time.hundreds = rtc.bin2bcd(0);

        dt.date.day = rtc.bin2bcd(30);
        dt.date.month = rtc.bin2bcd(6);
        //   dt.date.year = rtc.bin2bcd(15);

        //dt.date.year = rtc.bin2bcd(15);
        dt.date.year=rtc.bin2bcd(89);
        //   dt.date.century= 99;
        rtc.write(TIME, dt);
    */


    eject.fall(&flip);
    while(true) {
        dt = rtc.read(TIME);

        hours= (((dt.time.hours & 0xF0) >> 4) * 10) + (dt.time.hours & 0x0F);
        mins= (((dt.time.minutes & 0xF0) >> 4) * 10) + (dt.time.minutes & 0x0F);
        sec= (((dt.time.seconds & 0xF0) >> 4) * 10) + (dt.time.seconds & 0x0F);
        csec= (((dt.time.hundreds & 0xF0) >> 4) * 10) + (dt.time.hundreds & 0x0F);

        day= (((dt.date.day & 0xF0) >> 4) * 10) + (dt.date.day & 0x0F);
        month= (((dt.date.month & 0xF0) >> 4) * 10) + (dt.date.month & 0x0F);
        year= (((dt.date.year & 0xF0) >> 4) * 10) + (dt.date.year & 0x0F);


        //   century= (((dt.date.century & 0xF0) >> 4) * 10) + (dt.date.century & 0x0F);
        // century= dt.date.century;


        //  const char *filename = ("/sd/%d:%d:%d:%d:%d:%d.txt",hours,mins,sec,csec,day,month,year+100+1900);
        sprintf(name ,"/sd/%d-%d-%d-%d-%d-%d-%d.txt",hours,mins,sec,csec,day,month,year+100+1900);
        FILE *fp = fopen(name, "w");
        if(fp == NULL) {
            error("Could not open file for write\n");
            //  gled = 1;
            membad=0;

        }
        memok=0;
       // mplTemp = mpl.getTemperature();
        //   t.start();

        // while(flag<360000&& flagject!=1) {
        while(flag<360000) {
            //wait_ms(2.5);
            //if(t.read_ms ()==2.5) {
            enMMA8491 = on;

            //    sprintf(acele,"MMA8451: x:%f \ty: %f \tz:%f\t     MMA8491: x:%f \ty: %f \tz:%f \n",acc51.getAccX(),acc51.getAccY(),acc51.getAccZ(),acc91.getAccX(),acc91.getAccY(),acc91.getAccZ());
            fprintf(fp,"MMA8451: x:%f \ty: %f \tz:%f\t      ",acc51.getAccX(),acc51.getAccY(),acc51.getAccZ());
            fprintf(fp,"MMA8491: x:%f \ty: %f \tz:%f \n",acc91.getAccX(),acc91.getAccY(),acc91.getAccZ());

            //    fprintf(fp,acele);

            if(flagject ==1) {
               // mplTemp = mpl.getTemperature();
                //fprintf(fp,"Temp:%f \n",mplTemp);
                fclose(fp);
                memok=1;
                ejeok = 0;
                while(1);
            }
            // t.reset();
            flag++;
            enMMA8491 = off;
            // }
        }


        //  t.stop();
        //  t.reset();
       // fprintf(fp,"Temp:%f \n",mplTemp);
        /*
            if (flagject ==1) {
                fclose(fp);
                memok=1;
                ejeok = 0;
                while(1);
            }*/



        // fprintf(fp, "Hello fun SD Card World!");
        fclose(fp);
        flag=0;
        /* printf("%s\n",name);
         se.printf("%d:%d:%d:%d\n",hours,mins,sec,csec);
         printf("%d/%d////%d\n",day,month,year+100+1900);
         //  printf("%d/%d////%d\n",day,month,century);


         //enMMA8491 = off;

        //       mpl.Altimeter_Mode();

         enMMA8491 = on;


         mag.getValues(&magX, &magY, &magZ);
         mplAlt = mpl.getAltimeter();
         mplTemp = mpl.getTemperature();

         cout << "MMA8451: x:" << acc51.getAccX() << "\ty:" << acc51.getAccY() << "\tz:" << acc51.getAccZ() << "\n\r" << endl;
         se.printf("MMA8451: x:%f \ty: %f \tz:%f \n",acc51.getAccX(),acc51.getAccY(),acc51.getAccZ());
         cout << "MMA8491: " << acc91X << "\t" << acc91Y << "\t" << acc91Z << "\n\r" << endl;
         cout << "MMA8491: x:" << acc91.getAccX() << "\ty:" << acc91.getAccY() << "\tz:" << acc91.getAccZ() << "\n\r" << endl;
         cout << "MAG3110: " << magX << "\t" << magY << "\t" << magZ << "\n\r" << endl;
         mpl.Barometric_Mode();
         wait(holdTime);

         enMMA8491 = off;



         mplPres = mpl.getPressure();

         //cout << "Touch: " << tsi.readPercentage() << "\n\r" << endl;
         cout << "MPL3115: " << mplAlt << "\t" << mplPres << "\t" << mplTemp << "\n\r" << endl;
         mpl.Altimeter_Mode();
         wait(holdTime);*/


    }
    return 0;
}
