/*
 *  Output.cpp
 *  Theremi
 *
 *  Created by peccu on 11/09/12.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */
#include "stdlib.h"
#include "main.h"
#include "Output.h"
#include "lib.h"
#include "predict.h"
#include "svm-scale.h"
LocalFileSystem local("local");
Serial pc2(USBTX, USBRX); // tx, rx

void showDistance(int count){
    if(count>300){
        return;
    }
    printf("%4d",count);
    //std::cout << count;
    for(int i=0;i<(count-100);i++){
        printf(" ");
        //std::cout << " ";
    }
    printf("*\r\n");
    //std::cout << "*\r\n";
    return;
}

void showCounts(int *count,int size){
    for(int i=0;i<size;i++){
        printf("%d: %d\r\n",i, *(count+i));
        //std::cout << i << ": " << *(count+i) << "\r\n";
    }
}

// public method
Output::Output(void){
    counts=(int*)malloc(sizeof(int)*DIVISION);
    data=(int*)malloc((sizeof(int)*READSIZE*DIVISION)/THRESHOLD);
    for(int i=0;i<DIVISION;i++){
      *(counts+i)=0;
    }
    countNumber = 0;
    loopCounter = 0;
    prev = 1;
    init();
    ave = 0.0;
    var = 0.0;
}

void Output::init(void){
  windowSize=0;
  newCount=0;
}

void Output::reset(void){
    for(int i=0;i<DIVISION;i++){
        *(counts+i)=0;
    }
    countNumber = 0;
    loopCounter = 0;
    prev = 1;
    init();
    ave = 0.0;
    var = 0.0;
}

void Output::fopen(void){
#ifdef SAVE
/*    if ( NULL == (fp = fopen( "/local/test.csv", "w" )) ){
        error( "" );
    }
    if ( NULL == (fft = fopen( "/local/fft.csv", "w" )) ){
        error( "" );
    }
*/
    fp.open( "/local/test.csv" );
    fft.open( "/local/fft.csv" );
#endif
}

void Output::fclose(void){
#ifdef SAVE
    fp.close();
    fft.close();
#endif
}

bool Output::iterate(void){
  windowSize++;
#ifdef SAVE
    // for ( int i = 0; i < READSIZE; i++ ) {
    return loopCounter++<READSIZE;
#else
    return true;
#endif
}

void Output::write(float plus, float minus){
#ifdef SAVE
/*
  fprintf( fp, "%f\t%f\n", plus, minus );
  fprintf( fft, "%d %d\n", sum(counts,DIVISION),countNumber );
*/
  fp << plus << "\t" << minus << "\n";
  fft << sum(counts,DIVISION) << " " << countNumber << "\n";
#else
  showDistance(sum(counts,DIVISION));
#endif
    ave += sum(counts,DIVISION);
    *(data+countNumber-DIVISION) = sum(counts,DIVISION);
}

void Output::count(float plus, float minus){
    if(((plus-minus)*prev)<0){ // 0をまたいだ回数を数える
        newCount++;
        prev*=-1;
    }
    if (windowSize > THRESHOLD/DIVISION) {
        // ウィンドウサイズ分データが集まったらcountsにプッシュする
        countNumber++;// = pushed count
        if(countNumber>DIVISION-1){
            write(plus,minus);
        }
        counts = pushCount(counts,DIVISION,newCount);
        init();
    }
}

void Output::calcAveVar(void){
  int dataSize = countNumber-DIVISION+1;
  ave = average(data,dataSize)-(*data);
  var = variance(data,ave+(*data),dataSize);
}

void Output::writeTest(void){
/*    FILE *test;
    if ( NULL == (test = fopen( "/local/test.txt", "w" )) ){
        error( "" );
    }
*/
    std::ofstream ofs( "/local/test.txt" );
    
    ofs << "+0 1:" << ave << " 2:" << var << "\n";
    ofs.close();
/*
    fprintf(test,"+0 1:%f 2:%f\n",ave,var);
    fclose(test);
*/
    pc2.printf("+0 1:%f 2:%f\n",ave,var);
}

void Output::scale(void){
    main_scale();
}
void Output::predict(void){
    main_();
}

// デストラクタ
Output::~Output(){
#ifdef SAVE
/*
    fclose(fp);
    fclose(fft);
*/
fp.close();
fft.close();
#endif
}
