    #include "main.h"
    #include "lib.h"
    #include "Output.h"
    
    AnalogIn myinput20(p20);        // speaker minus
    AnalogIn myinput19(p19);        // speaker plus
    DigitalInOut io(p5);
    Serial pc(USBTX, USBRX); // tx, rx
    
    DigitalOut myled1(LED1);
    DigitalOut myled2(LED2);
    DigitalOut myled3(LED3);
    DigitalOut myled4(LED4);
    void lighton(void){
        myled1 = 1;
        myled2 = 1;
        myled3 = 1;
        myled4 = 1;
    }
    
    void lightoff(void){
        myled1 = 0;
        myled2 = 0;
        myled3 = 0;
        myled4 = 0;
    }
    
    int main (int argc, char * const argv[]) {
      //std::cout << "Hello, World!\n";
      io.mode( PullUp );
      io.input();
      io   = 0;
    
        // このへんでSVMのモデルを読み込む
        //main_();
    
        Output *out;
        out = new Output();
    
        float inplus,inminus;
    
        bool reset=false;
        while(!reset){
          // このループは認識を繰り返すループになると思う
            pc.printf("Let's start!");
            myled1 = 0;
            wait(1);
            lighton();
    
            out->reset();
            out->fopen();
    
            pc.printf("start\r\n");
            while(out->iterate()){
              // このループは一回の認識に必要な分のセンサデータを集める
              // まだOutputクラスに分離しきれてない
                inplus=(float)myinput19;
                inminus=(float)myinput20;
    
                // 0をまたいだ回数を数えてウィンドウサイズ分集まったらcountsにプッシュする
                out->count(inplus, inminus);
            }
            pc.printf("end\r\n");
            // ここで一回の認識に必要なセンサデータが集まっている
    
            // この辺で平均と分散を計算
            // lib.cppに関数書いた気がする
            out->calcAveVar();
            //pc.printf("\r");
    
            // この辺で平均と分散を2次元のデータとしてSVMで識別する
            out->writeTest();
            pc.printf("\r");
            out->scale();
            pc.printf("-sc\r");
            out->predict();
            pc.printf("\r");
    
            // この辺でマリオの曲を読み込んで，コンテキストごとにメロディを切り替えて再生
    
            out->fclose();
            lightoff();
            wait(1);
            // ここから，ループするかやめるか選ぶ入力待ち
            char c = 'a';
            while (1) {
                pc.printf("restart to type r\r\nreset to c :\r\n");
                c = pc.getc();
                if (c=='r') {
                    break;
                } else if (c=='c') {
                    reset=true;
                    break;
                }
            }
            // ここまで
        }
        pc.printf("reset!!\r\n");
        io.output();
        //mbed_reset();
    }
