#include "mbed.h"
#include "snd_wave_generator/SoundWaveGenerator.h"
#include "snd_wave_generator/TriangleWave.h"
#include "snd_wave_generator/SineWave.h"
#include "snd_wave_generator/WaveCombo.h"
#include <math.h>

using namespace snd_wave_generator;
Serial pc(USBTX, USBRX); // tx, rx
BusOut leds(LED1, LED2, LED4);
SoundWaveGenerator g(16000);

// code to code number
int code2int(char c){
  int ret = -1;
  switch(c){
  case 'C': ret = 0; break;
  case 'c': ret = 1; break; // C#/Db
  case 'D': ret = 2; break;
  case 'd': ret = 3; break; // D#/Eb
  case 'E': ret = 4; break;
  case 'F': ret = 5; break;
  case 'f': ret = 6; break; // F#/Gb
  case 'G': ret = 7; break;
  case 'g': ret = 8; break; // G#/Ab
  case 'A': ret = 9; break;
  case 'a': ret = 10; break; // A#/Bb
  case 'B': ret = 11; break;
  default:
    ret = -1;
  }
  //printf("case%d\r\n",ret);
  return ret;
}

// (C, C#, D, D#, E, F, F#, G, G#, A, A#, B)
float w(int ov,char code) {
  int note_no = code2int(code) + (ov + 2) * 12;
  return 440 * pow(2.0 , (note_no - 69) / 12.0 );
}

SineWave C3(w(3,'C'));SineWave C4(w(4,'C'));SineWave C5(w(5,'C'));
SineWave c3(w(3,'c'));SineWave c4(w(4,'c'));SineWave c5(w(5,'c'));
SineWave D3(w(3,'D'));SineWave D4(w(4,'D'));SineWave D5(w(5,'D'));
SineWave d3(w(3,'d'));SineWave d4(w(4,'d'));SineWave d5(w(5,'d'));
SineWave E3(w(3,'E'));SineWave E4(w(4,'E'));SineWave E5(w(5,'E'));
SineWave F3(w(3,'F'));SineWave F4(w(4,'F'));SineWave F5(w(5,'F'));
SineWave f3(w(3,'f'));SineWave f4(w(4,'f'));SineWave f5(w(5,'f'));
SineWave G3(w(3,'G'));SineWave G4(w(4,'G'));SineWave G5(w(5,'G'));
SineWave g3(w(3,'g'));SineWave g4(w(4,'g'));SineWave g5(w(5,'g'));
SineWave A3(w(3,'A'));SineWave A4(w(4,'A'));SineWave A5(w(5,'A'));
SineWave a3(w(3,'a'));SineWave a4(w(4,'a'));SineWave a5(w(5,'a'));
SineWave B3(w(3,'B'));SineWave B4(w(4,'B'));SineWave B5(w(5,'B'));
//3cdefgab 4cdefgab 5cdefgab

// play with length
void p(SineWave *s,float length){
  g.play(s);wait(length);
}
// stop length
void s(float stop){
  g.stop();wait(stop);
}

// defines of sound sequenses
void coin(void){
  p(&B4,0.05);
  p(&E5,0.35);
  s(0.2);
}

void mainTheme(void){
  p(&C3,0.3);
  s(0.2);
}


// main routin
int main() {
  // while(1) {
  coin();coin();coin();coin();coin();coin();coin();coin();coin();
  exit(0);
  //}
}
