#ifndef SERVO_PPM_H
#define SERVO_PPM_H

////////////////////////////////////////////////////////////////////////////////////
// servo and ppm out library
//uses timeout timers to provide servo PWM and PPM signal on any digital out pin
//(does not use internal PWM generators)
////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
// application example:
// a flysky RC receiver with 8 servos and PPM outputs, with FRDM-KL05Z platform.
// (receiver compatible with popular TH9X transmitter)
// Uses also A7105_FLYSKY_RX library to dialog with A7105SY or A7105CL 2.4Ghz module.
/*
#include "mbed.h"
#include "A7105_FLYSKY_RX.h"
#include "servo_ppm.h"

//A7105 module <-> KL05Z pin assignment
#define PIN_SDIO    PTA7    //SPI mosi
#define PIN_GIO1    PTA6    //SPI miso
#define PIN_SCK     PTB0    //SPI sck  
#define PIN_CS      PTA10   //CS
#define PIN_GIO2    PTA11   //wait rx

//servo <-> KL05Z pin assignment
#define PIN_SERVO1  PTB5
#define PIN_SERVO2  PTA12
#define PIN_SERVO3  PTB6
#define PIN_SERVO4  PTB7
#define PIN_SERVO5  PTB11
#define PIN_SERVO6  PTA5
#define PIN_SERVO7  PTA9
#define PIN_SERVO8  PTA8

//PPM <-> KL05Z pin assignment
#define PIN_PPM     PTB3

//A7105 flysky RX
A7105_flysky_RX rx(PIN_SDIO, PIN_GIO1, PIN_SCK, PIN_CS, PIN_GIO2, LED_GREEN); //mosi, miso, sck, cs, wait_rx, status_led)

//servo and ppm outputs
servo_ppm servoPpmOut( PIN_PPM, PIN_SERVO1, PIN_SERVO2, PIN_SERVO3,  PIN_SERVO4,  PIN_SERVO5,  PIN_SERVO6,  PIN_SERVO7,  PIN_SERVO8);
 
int main()
{      
    bool ok;
    
    //start servo/ppm frame
    servoPpmOut.startServoPpmOutput();
     
    //init A7105
    ok = rx.init();
    if (ok)
    {
        //bind TX
        ok = rx.bind(); //if bind failed, take default tx id
                            
        //infinite loop, receive packet and update servos
        while (1)
        {   
            //wait packet (1.46ms) or timeout(1.5ms) since last call to this function
            if ( rx.waitPacket() == NO_ERROR)
            {
                //update servo position
                for (int i=0; i<8; i++) servoPpmOut.setServoPulseDuration_us( i+1, rx.servoPulseDur[i] );
            }
        }
    }
}
*/
////////////////////////////////////////////////////////////////////////////////////

//macro
#define assign( ptr, val ) if(ptr!=NULL)*ptr=val

//default configuration
// frame period = 20000us = 20ms ( freq = 50Hz ) 
// minimum interval between frames = 4000us  = 4ms 
// minimum pulse duration = 1000us
// maximum pulse duration = 2000us
// PPM pumse duration = 400us

class servo_ppm
{
    public:
        // constructor for PPM and 0 to 8 servos
        servo_ppm( PinName PPM = NC,
            PinName S1 = NC, PinName S2 = NC, PinName S3 = NC, PinName S4 = NC,
            PinName S5 = NC, PinName S6 = NC, PinName S7 = NC, PinName S8 = NC);
       
        //function
        void startServoPpmOutput(void);
        void stopServoPpmOutput(void);
        void setServoPulseDuration_us(int numServo, int pulseDuration);
        
        //configuration functions
        void setFramePeriod_us( int val );
        void setMinFrameInterval_us( int val );
        void setMinServoPulseDuration_us( int val );
        void setMaxServoPulseDuration_us( int val );
        void setPpmPulseDuration_us( int val );
        
    private:
};

#endif