// Lecture de température adafruit MCP9808 en I2C

#include "mbed.h"

I2C i2c(PB_9, PB_8);            // Pin pour le bus I2C
Serial Com_Xbee(PC_10, PC_11);    // Pin pour le bus Serie avec Xbee
DigitalOut Led(PA_5);

volatile char buffer[256];
volatile int i=0;
volatile int j = 0;
char rxstring[9];

int Com_temperature;
int Com_lumiere;
char Com_capteur;
int Alarme;
int ptr = 0;

#define Address_Capteur  (0b00110010)           // addresse capteur TOR
#define Address_Temp (0b00110000)               // adresse capteur de temperature 0011 A0, A1, A2 = 0
#define Address_Lum (0b01110010)                // address capteur de lumiere 01110010 (pin address en l'air)

void reception()                                // interruption reception de donnée
{
    buffer[i++] = Com_Xbee.getc();
    ptr = 1;
    return;
}

int main()
{
    Com_Xbee.baud(9600);
    Com_Xbee.format(8, SerialBase::None, 1);
    Com_Xbee.attach(&reception);

    char Command_Register[1];
    char Control_Register[1];                    // Registre de configuration
    char Temperature[2];                        // Valeur de température cf datasheet MCP9808
    //char Buf[1];
    char Lumiere[2];
    char Capteur[1];


    //char rxstring[9];

    i2c.frequency(100000);
    Command_Register[0] = 0x02;
    Control_Register[0] = 0x03;                 // Registre contenant les 2 octets de température 0011000110  0000 0101
    // Temp_upper[1] = 0x8D;

    while(1) {

        Command_Register[0] = 0x02;
        Control_Register[0] = 0x03;                 // Registre contenant les 2 octets de température 0011000110  0000 0101
        i2c.start();
        i2c.write(Address_Capteur, Command_Register, 1, 0);
        i2c.write(Address_Capteur, Command_Register, 1, 0);
        i2c.read(Address_Capteur, Capteur,1, 0);
        //Command_Register[0] = 0xAC;
        //i2c.write(Address_Capteur, Command_Register, 1, 0);
        //i2c.read(Address_Capteur, Temp,2, 0);
        //i2c.stop();
        Command_Register[0] = 0x05;
        //i2c.start();
        i2c.write(Address_Temp, Command_Register, 1, 0);
        //i2c.write(Address_Temp, Command_Register, 1, 0);
        i2c.read(Address_Temp, Temperature,2, 0);
        Command_Register[0] = 0xA0;
        i2c.write(Address_Lum, Command_Register, 1, 0);
        i2c.write(Address_Lum, Control_Register, 1, 0);
        //i2c.read(Address_Lum, Buf, 1, 0);
        Command_Register[0] = 0xAC;
        i2c.write(Address_Lum, Command_Register, 1, 0);
        i2c.read(Address_Lum, Lumiere,2, 0);
        //i2c.write(Address_Capteur, Command_Register, 1, 0);
        // i2c.read(Address_Lum, Temp,1, 0);
        i2c.stop();

        if ((Temperature[0] & 0x01) == 0x10) {
            Temperature[0] = Temperature[0] & 0x0F;
            Com_temperature = (int)(256 - (Temperature[1] * 16 + Temperature[0] / 16.));
        } else {
            Com_temperature = (int)((Temperature[1] * 16 + Temperature[0] / 16.));
        }

        Com_lumiere = 256 * Lumiere[1] + Lumiere[0];

        Com_capteur = Capteur[0];
        Alarme = Capteur[0] & 0x02;

        wait_ms(100);

        // Com_Xbee.printf("E");

        if (ptr == 1) {                                     // Attente récupération de donnée
            if (buffer[0] == 'e' || buffer[0] == 'E') {      // Verification de la donnée envoyé

                Com_Xbee.printf("Carte Exterieure: \n");

                Com_Xbee.printf("temperature %2.1d|", Com_temperature);
                Com_Xbee.printf("luminosite %2.1d|", Com_lumiere);
            }
            if (buffer[0] == 'i' || buffer[0] == 'I') {      // Verification de la donnée envoyé

                Com_Xbee.printf("Carte Interieure: \n");
                Com_Xbee.printf(" alarme %1x|", Alarme);
                Com_Xbee.printf(" presence %1x|", Com_capteur);
                //Com_Xbee.printf(" presence %1x|", Com_capteur);
                Com_Xbee.printf("temperature %2.1d|", Com_temperature);
                Com_Xbee.printf("luminosite %2.1d|", Com_lumiere);
            }

            else if (buffer[0] == 'L' || buffer[0] == 'l') {
                Com_Xbee.printf("Vive Legrand");
            }

            i = 0;
        }
        ptr = 0;
        Led = !Led;
        wait(1.0);
    }
}

