#ifndef PID_H
#define PID_H

#include "pws.h"
#include "kompas.h"
#include "goto.h"
#include "roer.h"

class Pid{
    double p,i,d;
    double kp,ki,kd;
    double dt;
    double prev_error;
    int o;
    
    Goto * sp;
    Kompas * pv;
    Roer * output;
    
    public:
        Pid (Goto *, Kompas *, Roer *);
        
        void setKp(double k){kp = k;}
        void setKi(double k){ki = k;}
        void setKd(double k){kd = k;}
        
        double getP(void){return p;}
        double getI(void){return i;}
        double getD(void){return d;}
        double getKP(void){return kp;}
        double getKI(void){return ki;}
        double getKD(void){return kd;}
        double getE(void){return prev_error;}
        double getSP(void){return sp->get();}
        double getPV(void){return pv->get();}
        int getO(void){return o;}
        
        void update(void);
};

#endif