#include "mbed.h"

#include "pws.h"
#include "roer.h"
#include "zeil.h"
#include "kompas.h"
#include "status.h"
#include "gps_wrapper.h"
#include "route.h"
#include "vaantje.h"
#include "pid.h"


DigitalOut myled(LED1);
GPS g(NC, p27);
Gps gps(&g);
Kompas kompas;
Roer roer;

Route route(&gps);
Vaantje vaantje;
Zeil zeil;
Goto got(&gps,&route,&kompas,&vaantje);
Pid pid(&got,&kompas,&roer);
Status status(&roer,&zeil, &kompas, &gps, &vaantje, &route, &got, &pid);


int main() {
    while (1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);

    }
}
