#include "gps_wrapper.h"

Gps::Gps(GPS * g){    
    gps = g;
    gps->baud(9600);
    gps->format(8, GPS::None, 1);
    gps->setGga(gga);
    
}

void Gps::set(pos* new_pos){
    positie.lat = new_pos->lat;
    positie.lon = new_pos->lon;
}

pos Gps::get(void){
    positie.lat = gps->latitude();
    positie.lon = gps->longitude();
    return positie;
}

char* Gps::getgga(void){
    return gga;
}
void Gps::simuleer(double koers, double afstand){
    
    koers *= deg2rad;
    afstand /= 6371.0;
    
    double lat1 = positie.lat * deg2rad;
    double lon1 = positie.lon * deg2rad;
    
    double dlat = afstand * cos(koers);
    double lat2 = dlat + lat1;
    
    double df = log(tan(lat2/2.0 + PI/4.0)/tan(lat1/2.0 + PI/4.0));
    double q;
    if (df == 0)
        q = cos(lat1);
    else
        q = dlat / df;
    
    double dlon = afstand * sin(koers) / q;
    
    double lon2 = fmod((lon1 + dlon + PI),(2.0 * PI)) - PI;
    
    positie.lat = lat2 * rad2deg;
    positie.lon = lon2 * rad2deg;
}
