#include "mbed.h"
#include "GPS.h"


Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
PwmOut led3(LED3);
DigitalOut led4(LED4);
GPS gps(NC, p25);
PwmOut led2(LED2);
Timeout t2, t3, t4;
char buffer[30];


void send_message() {
    unsigned char x = 0;

    while (buffer[x] != 10) { //10 , 13 = \n
        while (pc.writeable() == 0);
        pc.putc(buffer[x]);
        x++;
    }
    pc.putc(10);
    pc.putc(13);

}


void serieel_lezen() {
    char lezen;
    while (pc.readable()) {
        lezen = pc.getc();
        if (lezen == 1) {
            while (pc.readable() == 0);
            lezen = pc.getc();
            led2 = lezen / 255.0;
        }
        if (lezen == 2) {
            while (pc.readable() == 0);
            lezen = pc.getc();
            led3 = lezen / 255.0;
        }
    }
}

int main() {
    GPS_Time q1;

    pc.baud(19200);
    pc.attach(&serieel_lezen);
    gps.baud(9600);
    gps.format(8, GPS::None, 1);





    while (1) {
        // Every 3 seconds, flip LED1 and print the basic GPS info.
        wait(3);
        led1 = 1;

        sprintf(buffer, "abcdefghijklmnopqrstuvwxyz\n");
        send_message();
        /*
        //gps.timeNow(&q1);
        //pc.printf("Method 1. Lat = %.4f ", gps.latitude());
        //pc.printf("Lon = %.4f ", gps.longitude());
        //pc.printf("Alt = %.4f ", gps.altitude());

        pc.printf("%02d:%02d:%02d %02d/%02d/%04d\r\n",
            q1.hour, q1.minute, q1.second, q1.day, q1.month, q1.year);

        // Alternative method that does the same thing.
        GPS_Time *q2 = gps.timeNow();
        pc.printf("Method 2. Lat = %.4f ", gps.latitude());
        pc.printf("Lon = %.4f ", gps.longitude());
        pc.printf("Alt = %.4f ", gps.altitude());
        pc.printf("%02d:%02d:%02d %02d/%02d/%04d\r\n\n",
            q2->hour, q2->minute, q2->second, q2->day, q2->month, q2->year);
        delete(q2);

        */
        led1 = 0;

    }
}
