#include "mbed.h"
#include "EthernetInterface.h"


DigitalOut led(LED1);

int main()
{
    printf("Server example\n\r");
    
    EthernetInterface eth;
    eth.set_network("192.168.0.40","255.255.255.0","192.168.0.1");
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    
    srv.bind(4000);
    
    srv.listen();
    
    while(true){
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &client_addr);
        
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
                    client_addr.get_port());
                    
        client.send(buffer, 256);
    
        client.close();
        
    }
}
