#include "StateMachine.h"

StateMachine::StateMachine()
{

    r = new PwmOut(D5);
    g = new PwmOut(D9);
    b = new PwmOut(D8);
    currentState = RED;

}

StateMachine::~StateMachine()
{
    delete r;
    delete g;
    delete b;
}

void StateMachine::start()
{
    while(true) {
        switch(currentState) {
            case RED:
                actionRed();
                currentState = GREEN;
                break;
            case GREEN:
                actionGreen();
                currentState = BLUE;
                break;
            case BLUE:
                actionBlue();
                currentState = RED;
                break;
            default:
                currentState = CERROR;
                return;
        }
    }
}

void StateMachine::actionRed()
{
    *r = 0.0;
    *g = 1.0;
    *b = 1.0;
    wait(1.0);
}

void StateMachine::actionGreen()
{
    *r = 1.0;
    *g = 0.0;
    *b = 1.0;
    wait(1.0);

}

void StateMachine::actionBlue()
{
    *r = 1.0;
    *g = 1.0;
    *b = 0.0;
    wait(1.0);
}

