#include "ICRS101.h"

PwmOut motor_left(MOTOR_LEFT_ENABLE);
PwmOut motor_right(MOTOR_RIGHT_ENABLE);

DigitalOut motor_left_a(MOTOR_LEFT_A);
DigitalOut motor_left_b(MOTOR_LEFT_B);
DigitalOut motor_right_a(MOTOR_RIGHT_A);
DigitalOut motor_right_b(MOTOR_RIGHT_B);

float global_speed = 0;

void run(float seconds);

void forward(float seconds) {

	motor_left_a = 1;
	motor_left_b = 0;

	motor_right_a = 1;
	motor_right_b = 0;

	run(seconds);
}

void backward(float seconds) {

	motor_left_a = 0;
	motor_left_b = 1;

	motor_right_a = 0;
	motor_right_b = 1;

	run(seconds);
}

void left(float seconds) {

	motor_left_a = 1;
	motor_left_b = 0;

	motor_right_a = 0;
	motor_right_b = 1;

	run(seconds);
}

void right(float seconds) {

	motor_left_a = 0;
	motor_left_b = 1;

	motor_right_a = 1;
	motor_right_b = 0;

	run(seconds);
}

void run(float seconds)
{
	motor_left = global_speed;
	motor_right = global_speed;
	wait(seconds);
	motor_left = 0;
	motor_right = 0;
}

void speed(float value) {
	global_speed = value;
}

void drive(){
    motor_left_a = 1;
    motor_left_b = 0;

    motor_right_a = 1;
    motor_right_b = 0;

    motor_left = global_speed;
    motor_right = global_speed;
}

void stop(){
	motor_left_a = 0;
    motor_left_b = 0;

    motor_right_a = 0;
    motor_right_b = 0;

    motor_left = 0;
    motor_right = 0;
}
