#include "mbed.h"

//Setting the output pins for the motor driver
DigitalOut RL(p15);
DigitalOut RH(p16);
DigitalOut LL(p17);
DigitalOut LH(p18);

//Setting an indicating LED
DigitalOut LED(LED1);

//Setting a Pin to power a switch 
DigitalOut On(p10);

//Setting the Input Pin
DigitalIn S1(p13);

//Function to get the motor to run one way
void Run_a(){
    RH = 1;
    LL = 1;
    LH = 0;
    RL = 0;    
}

//Function to get the motor to run another way
void Run_b(){
    LH = 1;
    RL = 1;
    RH = 0;
    LL = 0;  
}

//Function to turn off the motor
void off(){
    LH = 0;
    RL = 0;
    RH = 0;
    LL = 0;  
}

//Function to set the motor to 0V
void discharge(){
    LH = 0;
    RL = 1;
    RH = 0;
    LL = 1; 
}

//Function to test the operation of the pins
void test(){
    LH = 1;
    RL = 1;
    RH = 1;
    LL = 1; 
}

int main() {
    
    On = 1;
    
    //Initial setting the motor to 0V and switching off
    discharge();
    off();
    
    while(1) {
        //Wait until the motor is on
        if(S1 == 1){
            LED = 1;
            //Turning the motor on for a set time
            test();
            wait(0.045);
            off();
            //A wait time to stop de-bouncing from the switch
            wait(0.5);
        }
        LED = 0;
    }
}
