#include "mbed.h"
//Including the PID Library
#include "PID.h"

//Setting the PWM output for Gate Driver
PwmOut boostIn(p22);

//Setting the Analgoue input Pins for the feedback
AnalogIn Vin(p20);
AnalogIn Iin(p19);

//Setting the Motor Driver Outputs
DigitalOut RL(p15);
DigitalOut RH(p16);
DigitalOut LL(p18);
DigitalOut LH(p19);

//Setting Indicating LEDs
DigitalOut LED(LED1);

//Setting the Input pin for the switch
InterruptIn S1(p13);

//Setting up the timer
Timer run_time;

//Setting up a serial connection for debugging 
Serial pc(USBTX, USBRX); // tx, rx

//Setting the Voltage feedback variables, these are different due to the absences of current feedback
const double RATE_V = 0.001;
const double Kc = 0.8;
const double Ti = 0.2;
const double Td = 0.0; 

//Setting the voltage feedback function
PID Voltage(Kc, Ti, Td, RATE_V);

//Setting the current feedback variables
const double RATE_I = 0.001;
const double Kc_I = 5;
const double Ti_I = 5;
const double Td_I = 0;

//Setting teh current feedback function
PID Current(Kc_I, Ti_I, Td_I, RATE_I);

//Setting the desired output
const double voltage_goal = 30;

//Initialling the feedback parameters
void initializePidControllers(void){
 
    //The voltage feedback values are different due to the absences of current feedback
    Voltage.setInputLimits(0.0,40.0);
    Voltage.setOutputLimits(0.0, 1.0);
    Voltage.setMode(AUTO_MODE);

    Current.setInputLimits(0.0,60.0);
    Current.setOutputLimits(0.0, 1.0);
    Current.setMode(AUTO_MODE);
 
}

//Motor driver functions, see motor driver code
void Run_a(){
    RH = 1;
    LL = 1;
    LH = 0;
    RL = 0;    
}

void Run_b(){
    LH = 1;
    RL = 1;
    RH = 0;
    LL = 0;  
}

void off(){
    LH = 0;
    RL = 0;
    RH = 0;
    LL = 0;  
}

void discharge(){
    LH = 0;
    RL = 1;
    RH = 0;
    LL = 1; 
}

//Interrupt function to disable interrupts, run motor and start timer
void Motor_Run(){
    S1.disable_irq();
    Run_a();
    LED = 1;
    run_time.start();
}

int main() {
    
    //Making sure motor and LED is off
    LED = 0;
    off();

    //Testing serial connection
    pc.printf("Hello\n\r");
    
    //Setting the period for the PWM
    boostIn.period_us(5);
    
    //Setting the PID controllers and the output voltage
    initializePidControllers();
    Voltage.setSetPoint(voltage_goal);
    
    double current_voltage = 0;
    double current_Current = 0;
    double num = 0.5;
    
    int n = 0;
    
    //Setting the interrup to occur on the rising edge of the pin
    S1.rise(&Motor_Run);
    
    int count = 0;
    float check = 0;
    
    //Setting the motor on time
    int motor_on_time = 45;
    
    float ref_current = 0;
    float V_in = 12;
    double delta = 0;
    
    while(1){
        //Reading in the output Voltage and adjusting it to volts
        current_voltage = Vin.read()*3.3*13.1;
        //Computing the Voltage PID and reading the output
        Voltage.setProcessValue(current_voltage);
        num = Voltage.compute();
        //Setting the PWM with a new duty cycle, for just voltage feedback
        boostIn.write(1-num);
        
        //Code for current feedback
        /*
        ref_current = (num*current_voltage)/V_in;
        current_Current = Iin.read();
        ref_current = ref_current - current_Current;
        Current.setProcessValue(ref_current);
        delta = Current.compute();
        delta = delta/V_in;
        boostIn.write(delta);
        */

        check = boostIn.read();
        //Checking values for debugging every 100 loops
        if(n > 100){
            pc.printf("%f  %f \r\n",current_voltage, boostIn.read());
            n = 0;
        }else{
            n++;
        }
        
        //Waiting for new collection points for the Voltage feedback
        wait(RATE_V);
        
        //Turning the motor off after set time
        if(run_time.read_ms() > motor_on_time){
            off();
        }
        //Enabling the switch again and reseting the timer
        if(run_time.read() > 0.5){
            LED = 0;
            run_time.stop();
            run_time.reset();
            S1.enable_irq();
            off();
        }
    }
}
