#include "mbed.h"
#include "PID.h"

PwmOut boostIn(p22);
AnalogIn Vin(p20);
AnalogIn Iin(p19);
DigitalOut L1(LED1);
DigitalOut L2(LED2);

Serial pc(USBTX, USBRX); // tx, rx

const double RATE_V = 0.001;
const double Kc = 1.5;//100;
const double Ti = 0.08;//800;
const double Td = 0.0; 

PID Voltage(Kc, Ti, Td, RATE_V);

const double RATE_I = 0.001;
const double Kc_I = 1;
const double Ti_I = 1;
const double Td_I = 1;

PID Current(Kc_I, Ti_I, Td_I, RATE_I);

const double voltage_goal = 30;

void initializePidControllers(void){
 
    Voltage.setInputLimits(0.0,40.0);
    Voltage.setOutputLimits(0.0, 1.0);
    Voltage.setMode(AUTO_MODE);
    //Voltage.setBias(0.5);
 
}

int main() {

    pc.printf("Hello\n\r");
    
    boostIn.period_us(5);
    
    initializePidControllers();
    Voltage.setSetPoint(voltage_goal);
    
    double current_voltage = 0;
    double error = 0;
    double num = 0.5;
        
    while(1){
        //Reading in the output Voltage and adjusting it to volts
        current_voltage = Vin.read()*3.3*13.1;
        //Computing the Voltage PID and reading teh output
        Voltage.setProcessValue(current_voltage);
        num = Voltage.compute();
        //Setting the PWM with a new duty cycle, for just voltage feedback
        boostIn.write(1-num);
        wait(RATE_V);
        //L1 = !L1;
    }
}
