#include "Motor.h"


Motor::Motor(PinName pin1, PinName pin2) : pwm1(pin1), pwm2(pin2)
{
    const float period = 1/20000.0f;
    
    pwm1.period(period);
    pwm2.period(period);
    
    pwm1 = 0.0f;
    pwm2 = 0.0f;
}


void Motor::speed(float value)
{
    if (value < 0.0f)
    {
        pwm1 = value;
        pwm2 = 0.0f;
    }
    else
    {
        pwm1 = 0.0f;
        pwm2 = -value;
    }
}


Motor& Motor::operator=(float value)
{
    speed(value);
    return *this;
}


void Motor::brake()
{
    pwm1 = 1.0f;
    pwm2 = 1.0f;
}
