/*
 * main.cpp
 *
 * Copyright (c) 2011 Peter Brier
 *
 *   This file is part of the LaOS project (see: http://laoslaser.org)
 *
 *   LaOS is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   LaOS is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with LaOS.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This program tests the inputs and outputs of the laoslaser v1 board
 * LED1 = xhome
 * LED2 = yhome
 * LED3 = zmin
 * LED4 = zmax
 *
 */
#include "mbed.h"
#include "SDFileSystem.h"

// USB Serial
Serial pc(USBTX, USBRX); // tx, rx

// SD card
SDFileSystem sd(p11, p12, p13, p14, "sd");

// Analog in/out (cover sensor) + NC
DigitalIn cover(p19);

// I2C
I2C i2c(p9, p10);        // sda, scl
#define _I2C_ADDRESS 0x04
#define _I2C_HOME 0xFE
#define _I2C_CLS 0xFF
#define _I2C_BAUD 10000

// status leds
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Inputs;
DigitalIn xhome(p8);
DigitalIn yhome(p17);
DigitalIn zmin(p15);
DigitalIn zmax(p16);


// motors
DigitalOut enable(p7);
DigitalOut xdir(p23);
DigitalOut xstep(p24);
DigitalOut ydir(p25);
DigitalOut ystep(p26);
DigitalOut zdir(p27);
DigitalOut zstep(p28);

// laser
DigitalOut o1(p22);
DigitalOut o2(p21);
DigitalOut o3(p6);
DigitalOut o4(p5);

void home()
{
  int i=0;
  xdir = 0;
  ydir = 0;
  zdir = 0;
  led1 = 0;
  while ( 1 )
  {
    xstep = ystep = 0;
    wait(0.0001);
    xstep = xhome;
    ystep = yhome;
    wait(0.0001);
    
    led2 = !xhome;
    led3 = !yhome;
    led4 = ((i++) & 0x10000);
    if ( (!xhome) && (!yhome) ) return;
  }
}

#define TEST(c,x) case c: x = !x; printf("Test %c: " #x " is now %s \r\n", c, (x ? "ON" : "OFF")); break 

/**
*** main()
**/
int main() 
{
  led1 = led2 = led3 = led4 = 1;

  i2c.frequency(_I2C_BAUD);
  pc.baud(115200);

  xhome.mode(PullUp);
  yhome.mode(PullUp);
  zmin.mode(PullUp);
  zmax.mode(PullUp); 
  
  printf("Peforming io test, press 'X' to exit\r\n");
  home();
  int i=0;
  int test=0;
  while( 1 )
  {
    i++;
    led1 = xhome;
    led2 = yhome;
    led3 = zmin;
    led4 = zmax;
    if ( pc.readable() )
      test = pc.getc();
    else 
      test = 0;
    switch( test )
    {
      TEST('e',enable);
      TEST('X',xdir);
      TEST('x',xstep);
      TEST('Y',ydir);
      TEST('y',ystep);
      TEST('Z',zdir);
      TEST('z',zstep);
      TEST('1',o1);
      TEST('2',o2);
      TEST('3',o3);
      TEST('4',o4);
      case 's':
        char buf[32];
        memset(buf,0,sizeof(buf));
        printf("Testing IO board SD card: Write...\r\n");
        FILE *test1 = fopen("/sd/text.txt", "wb");
        fwrite("bla bla\n",8, 1, test1); 
        fclose(test1);
        printf("Testing IO board SD card: Read...\r\n");
        test1 = fopen("/sd/text.txt", "rb");
        fread(&buf,8, 1, test1); 
        printf("Result: '%s'\r\n", buf);
        fclose(test1);
        break;
      case 'i': 
        printf("I2C test:\r\n");
        char s[32], key;
        int result;
        sprintf(s,"Hello world!");
        i2c.write(_I2C_ADDRESS, s, strlen(s));
        wait(0.01);
        result = i2c.read(_I2C_ADDRESS,&key, 1);
        printf("Result=%d, key=%d\r\n", result, key);
        break;
      case 'c':
       printf("Cover switch: %s\r\n", (cover ? "OPEN" : "CLOSED"));
       break;
    }
    if ( test ) 
    {
      printf("xhome=%d, yhome=%d, zmin=%d, zmax=%d\n\r", (int)xhome, (int)yhome, (int)zmin, (int)zmax);
    }
  }
}
