#include "TS_DISCO_F429ZI.h"
#include "Keyboard_TS.h"

TS_DISCO_F429ZI ts;


KeyboardTs::KeyboardTs(uint8_t colnum) {
    ts.Init(240,320);
    if(colnum>=1 && colnum<=3) 
        column=colnum;
    else
        column=1;
    }
    
 enum KeyboardState KeyboardTs::eRead(void){
    TS_StateTypeDef TS_State;
    ts.GetState(&TS_State);
    
    if (TS_State.TouchDetected && TS_State.X>(80*(column-1)) && TS_State.X<80*column  &&  TS_State.Y <80){
        return BUTTON_0;
    }
    else if(TS_State.TouchDetected && TS_State.X>(80*(column-1)) && TS_State.X<80*column && TS_State.Y>=80 && TS_State.Y <160){
        return BUTTON_1;
    }
    else if (TS_State.TouchDetected && TS_State.X>(80*(column-1)) &&  TS_State.X<80*column && TS_State.Y>=160 && TS_State.Y <240){
        return BUTTON_2;
    }
    else if (TS_State.TouchDetected && TS_State.X>(80*(column-1)) &&  TS_State.X<80*column && TS_State.Y>=240 && TS_State.Y <320){
        return BUTTON_3;
    }
    else{
        return RELASED;
    }
}
   