#include "TS_DISCO_F429ZI.h"
#include "Keyboard_TS.h"

TS_DISCO_F429ZI ts;



KeyboardTs::KeyboardTs(uint8_t colnum) {
    ts.Init(240,320);
    if(colnum>=1 && colnum<=3) 
        column=colnum;
    else
        column=1;
    }
    
 enum KeyboardState KeyboardTs::eRead(void){
    TS_StateTypeDef TS_State;
    ts.GetState(&TS_State);
    
    if (TS_State.TouchDetected && TS_State.X>(80*(column-1)) && TS_State.X<80*column  &&  TS_State.Y <80){
        return BUTTON_0;
    }
    else if(TS_State.TouchDetected && TS_State.X>(80*(column-1)) && TS_State.X<80*column && TS_State.Y>=80 && TS_State.Y <160){
        return BUTTON_1;
    }
    else if (TS_State.TouchDetected && TS_State.X>(80*(column-1)) &&  TS_State.X<80*column && TS_State.Y>=160 && TS_State.Y <240){
        return BUTTON_2;
    }
    else if (TS_State.TouchDetected && TS_State.X>(80*(column-1)) &&  TS_State.X<80*column && TS_State.Y>=240 && TS_State.Y <320){
        return BUTTON_3;
    }
    else{
        return RELASED;
    }
    
    
     void KeyboardTs::On(uint8_t ButtonNum) {
    
    uint8_t x_pos;
    
    switch(column) {
        case 1: x_pos=0; break;
        case 2: x_pos=79; break;
        case 3: x_pos=159; break;
        }
    
    
        ButtonNoPushed(x_pos,0,80,80);
        ButtonNoPushed(x_pos,79,80,80);
        ButtonNoPushed(x_pos,159,80,80);
        ButtonNoPushed(x_pos,239,80,80); 
        
        if(ButtonNum==0) {
           ButtonPushed(x_pos,0,80,80); 
            } 
        else if(ButtonNum==1)  {
            ButtonPushed(x_pos,79,80,80);
         }
         else if(ButtonNum==2) {
            ButtonPushed(x_pos,159,80,80);
             }    
        else if(ButtonNum==3) {
            ButtonPushed(x_pos,239,80,80);
            }
            else if(ButtonNum==4) {
                }
        
        SetString(x_pos,0,(uint8_t *)"0",LEFT_MODE);
        SetString(x_pos,79,(uint8_t *)"1",LEFT_MODE);
        SetString(x_pos,159,(uint8_t *)"2",LEFT_MODE);  
        SetString(x_pos,239,(uint8_t *)"3",LEFT_MODE); 
    }   
    
}
   