#include "mbed.h"
#include "Led_Lcd.h"

LCD_DISCO_F429ZI lcd;

void LedLcd::ButtonNoPushed(uint16_t x_pos,uint16_t y_pos, uint16_t width, uint16_t height){
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(x_pos,y_pos,width,height);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(x_pos+1,y_pos+1,width-1,height-1);
    }
void LedLcd::ButtonPushed(uint16_t x_pos,uint16_t y_pos, uint16_t width, uint16_t height) {
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(x_pos,y_pos,width,height);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(x_pos+1,y_pos+1,width-1,height-1);
    }
    
void LedLcd::SetString(uint8_t x_pos,uint8_t y_pos,uint8_t *pText, Text_AlignModeTypdef mode) {
    lcd.SetFont(&Font24);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.DisplayStringAt(x_pos, y_pos,pText, mode);
    }
    
LedLcd::LedLcd(uint8_t num) {
    lcd.Clear(LCD_COLOR_BLACK);
    if(num>=1 && num<=3) 
        column=num;
    else
        column=1;
    
    }

    
