#include "mbed.h"
#include "Led_Lcd.h"

LCD_DISCO_F429ZI lcd;

void LedLcd::ButtonNoPushed(uint16_t x_pos,uint16_t y_pos, uint16_t width, uint16_t height){
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(x_pos,y_pos,width,height);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(x_pos+1,y_pos+1,width-1,height-1);
    }
void LedLcd::ButtonPushed(uint16_t x_pos,uint16_t y_pos, uint16_t width, uint16_t height) {
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(x_pos,y_pos,width,height);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(x_pos+1,y_pos+1,width-1,height-1);
    }
    
void LedLcd::SetString(uint8_t x_pos,uint8_t y_pos,uint8_t *pText, Text_AlignModeTypdef mode) {
    lcd.SetFont(&Font24);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.DisplayStringAt(x_pos, y_pos,pText, mode);
    }
    
LedLcd::LedLcd() {
    lcd.Clear(LCD_COLOR_BLACK);
    }
    
 void LedLcd::On(uint8_t ButtonNum) {
    
        ButtonNoPushed(0,0,80,80);
        ButtonNoPushed(0,79,80,80);
        ButtonNoPushed(0,159,80,80);
        ButtonNoPushed(0,239,80,80); 
        
        if(ButtonNum==0) {
           ButtonPushed(0,0,80,80); 
            } 
        else if(ButtonNum==1)  {
            ButtonPushed(0,79,80,80);
         }
         else if(ButtonNum==2) {
            ButtonPushed(0,159,80,80);
             }    
        else if(ButtonNum==3) {
            ButtonPushed(0,239,80,80);
            }
            else if(ButtonNum==4) {
                }
        
        SetString(0,0,(uint8_t *)"0",LEFT_MODE);
        SetString(0,79,(uint8_t *)"1",LEFT_MODE);
        SetString(0,159,(uint8_t *)"2",LEFT_MODE);  
        SetString(0,239,(uint8_t *)"3",LEFT_MODE); 
    }   
    