#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"


LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;





void ButtonNoPushed(uint16_t x_pos,uint16_t y_pos, uint16_t width, uint16_t height){
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(x_pos,y_pos,width,height);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(x_pos+1,y_pos+1,width-1,height-1);
    }
void ButtonPushed(uint16_t x_pos,uint16_t y_pos, uint16_t width, uint16_t height) {
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(x_pos,y_pos,width,height);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(x_pos+1,y_pos+1,width-1,height-1);
    }
    
void SetString(uint8_t x_pos,uint8_t y_pos,uint8_t *pText, Text_AlignModeTypdef mode) {
    lcd.SetFont(&Font24);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.DisplayStringAt(x_pos, y_pos,pText, mode);
    }
    



int main() {
    TS_StateTypeDef TS_State;
    ts.Init(240,320);
    lcd.Clear(LCD_COLOR_BLACK);
    
    while(1) {
        wait(0.1);
        
        ts.GetState(&TS_State);
        ButtonNoPushed(0,0,80,80);
        ButtonNoPushed(0,79,80,80);
        ButtonNoPushed(0,159,80,80);
        ButtonNoPushed(0,239,80,80); 
        
        if (TS_State.TouchDetected && TS_State.X<80 &&  TS_State.Y <80) {
            ButtonPushed(0,0,80,80);
           } 
   
        if (TS_State.TouchDetected && TS_State.X<80 && TS_State.Y>=80 && TS_State.Y <160) {
            ButtonPushed(0,79,80,80);
            }

            
        if (TS_State.TouchDetected && TS_State.X<80 && TS_State.Y>=160 && TS_State.Y <240) {
            ButtonPushed(0,159,80,80);
            }
            
            
        if (TS_State.TouchDetected && TS_State.X<80 && TS_State.Y>=240 && TS_State.Y <320) {
            ButtonPushed(0,239,80,80);
            }
       
 
                    
                   
         SetString(0,0,(uint8_t *)"0",LEFT_MODE);
         SetString(0,79,(uint8_t *)"1",LEFT_MODE);
         SetString(0,159,(uint8_t *)"2",LEFT_MODE);  
         SetString(0,239,(uint8_t *)"3",LEFT_MODE);     
    }

    
    }
    
    

